/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web;

import com.ajaxjs.util.collection.MapHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class WebUtil {
    public static String Mappath(ServletContext cxt, String relativePath) {
        String absolute = cxt.getRealPath(relativePath);
        if (absolute != null) {
            absolute = absolute.replace('\\', '/');
        }
        return absolute;
    }

    public static String Mappath(HttpServletRequest request, String relativePath) {
        return WebUtil.Mappath(request.getServletContext(), relativePath);
    }

    public static String getBasePath(HttpServletRequest request) {
        String prefix = request.getScheme() + "://" + request.getServerName();
        int port = request.getServerPort();
        if (port != 80) {
            prefix = prefix + ":" + port;
        }
        return prefix + "/" + request.getContextPath();
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (!"unknown".equalsIgnoreCase(ip) && ip != null && ip.length() != 0) {
            int index = ip.indexOf(",");
            if (index != -1) {
                ip = ip.substring(0, index);
            }
            return ip;
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String remoteConsole(HttpServletRequest request) {
        String msg = "";
        Map requestMap = new MapHelper().setParameterMapRaw(request.getParameterMap()).toMap().ignoreField("url").ignoreField("action").getParameterMap_String();
        msg = requestMap.size() > 0 ? MapHelper.join((Map)requestMap) : "\u6ca1\u6709\u53c2\u6570";
        return String.format("(function(){console.log('%s');})();", msg);
    }

    public static String httpProxy(HttpServletRequest request) {
        String url = request.getParameter("url");
        new MapHelper().setParameterMapRaw(request.getParameterMap()).ignoreField("url");
        String params = MapHelper.join((Map)new MapHelper().setParameterMapRaw(request.getParameterMap()).toMap().ignoreField("url").getParameterMap_String(), (String)"&");
        return url + '?' + params;
    }

    public static String[] getAllLocalHostIP() {
        InetAddress[] addrs = null;
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            addrs = InetAddress.getAllByName(hostName);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String[] ips = new String[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            ips[i] = addrs[i].getHostAddress();
        }
        return ips;
    }

    public static String getIpByHostName(String hostname) {
        try {
            return InetAddress.getByName(hostname).getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean ping(String ip) {
        try {
            return InetAddress.getByName(ip).isReachable(5000);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        String t = "     ___       _       ___  __    __      _   _____        _          __  _____   _____  \n     /   |     | |     /   | \\ \\  / /     | | /  ___/      | |        / / | ____| |  _  \\ \n    / /| |     | |    / /| |  \\ \\/ /      | | | |___       | |  __   / /  | |__   | |_| |  \n   / / | |  _  | |   / / | |   }  {    _  | | \\___  \\      | | /  | / /   |  __|  |  _  {  \n  / /  | | | |_| |  / /  | |  / /\\ \\  | |_| |  ___| |      | |/   |/ /    | |___  | |_| |  \n /_/   |_| \\_____/ /_/   |_| /_/  \\_\\ \\_____/ /_____/      |___/|___/     |_____| |_____/ \n";
        System.out.println(t);
    }
}

