/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.test;

import com.ajaxjs.js.JsonHelper;
import com.ajaxjs.util.collection.MapHelper;
import com.ajaxjs.web.test.DummyController;
import com.ajaxjs.web.test.DummyFilter;
import com.ajaxjs.web.test.WebBaseInit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockRequest {
    public static HttpServletRequest mockRequest(String contextPath, String path) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)(contextPath + path));
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)(contextPath + path));
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)contextPath);
        return request;
    }

    public HttpServletRequest initRequest(HttpServletRequest request, Map<String, String> formBody, boolean isByGetParams) throws IOException {
        if (isByGetParams) {
            for (String key : formBody.keySet()) {
                Mockito.when((Object)request.getParameter(key)).thenReturn((Object)formBody.get(key));
            }
        } else {
            String form = MapHelper.join(formBody, (String)"&");
            final ByteArrayInputStream is = new ByteArrayInputStream(form.getBytes());
            Mockito.when((Object)request.getInputStream()).thenReturn((Object)new ServletInputStream(){

                public int read() throws IOException {
                    return is.read();
                }
            });
        }
        return request;
    }

    public HttpServletRequest initRequest(String entry) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)("/new_test/service/" + entry));
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)("/new_test/service/" + entry));
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/new_test");
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        final HashMap hash = new HashMap();
        Answer<String> aswser = new Answer<String>(){

            public String answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                Object obj = hash.get(args[0].toString());
                return obj == null ? null : obj.toString();
            }
        };
        Mockito.when((Object)request.getAttribute("isRawOutput")).thenReturn((Object)true);
        Mockito.when((Object)request.getAttribute("errMsg")).thenAnswer((Answer)aswser);
        Mockito.when((Object)request.getAttribute("output")).thenAnswer((Answer)aswser);
        Mockito.when((Object)request.getAttribute("msg")).thenAnswer((Answer)aswser);
        ((HttpServletRequest)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                hash.put(args[0].toString(), args[1]);
                return "called with arguments: " + args;
            }
        }).when((Object)request)).setAttribute(Matchers.anyString(), (Object)Matchers.anyString());
        return request;
    }

    public static String doRequest(HttpServletRequest request, HttpServletResponse response) {
        DummyController controller = new DummyController();
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        DummyFilter filter = new DummyFilter();
        try {
            controller.init(WebBaseInit.initServletConfig(DummyController.class));
            filter.init(WebBaseInit.initFilterConfig(controller.getServletContext()));
            filter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
            controller.doGet(request, response);
            return response.getWriter().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> shouldbe_json_return(String js_code) {
        return JsonHelper.parseMap((String)js_code);
    }

    public Map<String, Object>[] shouldbe_jsonArray_return(String js_code) {
        List list = JsonHelper.parseList((String)js_code);
        return list.toArray(new Map[list.size()]);
    }

    public boolean shouldbe_hasRecord(Map<String, Object> json) {
        int total = (Integer)json.get("total");
        return total > 0;
    }

    public static void mockSession(HttpServletRequest request, final Map<String, Object> map) {
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        Mockito.when((Object)request.getSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getAttribute(Matchers.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                String key = (String)aInvocation.getArguments()[0];
                return map.get(key);
            }
        });
        ((HttpSession)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                String key = (String)aInvocation.getArguments()[0];
                Object value = aInvocation.getArguments()[1];
                map.put(key, value);
                return null;
            }
        }).when((Object)session)).setAttribute(Matchers.anyString(), Matchers.anyObject());
    }
}

