/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.tools;

import com.ajaxjs.mvc.controller.IController;
import com.ajaxjs.simpleApp.Constant;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.io.FileUtil;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.web.WebUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.mvc.annotation.Controller;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

@Controller
public abstract class BasePageEditor
implements IController,
Constant {
    private static final LogHelper LOGGER = LogHelper.getLog(BasePageEditor.class);
    private static final String startToken = "<!-- Editable AREA|START -->";
    private static final String endToken = "<!-- Editable AREA|END -->";
    private static final String jsonTpl = "{\"result\" : [%s], \"total\" : %s}";

    @GET
    public String show() {
        return "/asset/common/jsp/pageEditor/loadIframe.jsp";
    }

    @GET
    @Path(value="loadPage")
    public String loadPage(HttpServletRequest request) {
        if (request.getParameter("url") == null) {
            throw new NullPointerException("\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570 url\uff01");
        }
        String path = request.getParameter("url");
        try {
            path = BasePageEditor.getFullPathByRequestUrl(WebUtil.Mappath(request, path));
            request.setAttribute("contentBody", (Object)BasePageEditor.read_jsp_fileContent(path));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "/asset/common/jsp/pageEditor/editor.jsp";
    }

    @POST
    public String save(HttpServletRequest request) {
        try {
            if (request.getParameter("url") == null) {
                throw new NullPointerException("\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570 url\uff01");
            }
            if (request.getParameter("contentBody") == null) {
                throw new NullPointerException("\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570 contentBody\uff01");
            }
            String contentBody = request.getParameter("contentBody");
            String path = WebUtil.Mappath(request, request.getParameter("url"));
            BasePageEditor.save_jsp_fileContent(path, contentBody);
            return String.format("json::{\"isOk\": true, \"msg\" : \"%s\"}", "\u4fee\u6539\u9875\u9762\u6210\u529f\uff01");
        }
        catch (Throwable e) {
            return String.format("json::{\"isOk\": false, \"msg\" : \"%s\"}", e.toString());
        }
    }

    public static String read_jsp_fileContent(String fullFilePath) throws IOException {
        String jsp_fileContent = FileUtil.openAsText((String)fullFilePath);
        int start = jsp_fileContent.indexOf(startToken);
        int end = jsp_fileContent.indexOf(endToken);
        try {
            jsp_fileContent = jsp_fileContent.substring(start + startToken.length(), end);
        }
        catch (StringIndexOutOfBoundsException e) {
            jsp_fileContent = null;
            String msg = "\u9875\u9762\u6587\u4ef6" + fullFilePath + "\u4e2d\u6ca1\u6709\u6807\u8bb0\u53ef\u7f16\u8f91\u533a\u57df\u4e4b\u6807\u8bc6\u3002\u8bf7\u53c2\u8003\uff1a" + startToken + "/" + endToken;
            LOGGER.info(msg);
            throw new IOException(msg);
        }
        return jsp_fileContent;
    }

    public static String getFullPathByRequestUrl(String rawFullFilePath) {
        if (rawFullFilePath.indexOf(".jsp") == -1 && rawFullFilePath.indexOf(".htm") == -1) {
            rawFullFilePath = rawFullFilePath + "/index.jsp";
        }
        if (rawFullFilePath.indexOf("?") != -1) {
            rawFullFilePath = rawFullFilePath.replaceAll("\\?.*$", "");
        }
        return rawFullFilePath;
    }

    public static void save_jsp_fileContent(String rawFullFilePath, String newContent) throws IOException {
        String fullFilePath = BasePageEditor.getFullPathByRequestUrl(rawFullFilePath);
        String jsp_fileContent = FileUtil.openAsText((String)fullFilePath);
        String toDel_fileContent = BasePageEditor.read_jsp_fileContent(fullFilePath);
        if (toDel_fileContent == null) {
            throw new IOException("\u9875\u9762\u6587\u4ef6\u4e2d\u6ca1\u6709\u6807\u8bb0\u53ef\u7f16\u8f91\u533a\u57df\u4e4b\u6807\u8bc6\u3002\u8bf7\u53c2\u8003\uff1a startToken/endTpoken");
        }
        jsp_fileContent = jsp_fileContent.replace(toDel_fileContent, newContent);
        ((FileUtil)new FileUtil().setFilePath(fullFilePath).setContent(jsp_fileContent)).save().close();
    }

    public static String getImgList(String folder) {
        File dir = new File(folder);
        File[] files = dir.listFiles();
        ArrayList json = new ArrayList();
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            String strFileName;
            if (!files[i].isDirectory() && !(strFileName = files[i].getName()).contains(".jpg") && !strFileName.contains(".gif") && !strFileName.contains(".png")) continue;
        }
        return String.format(jsonTpl, StringUtil.stringJoin(json, (String)","), json.size());
    }

    public static boolean delFile(String file) {
        return new File(file).delete();
    }

    public String uploadFile() {
        String json = null;
        return json;
    }
}

