/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.upload;

import com.ajaxjs.util.Encode;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.io.FileUtil;
import com.ajaxjs.util.io.StreamUtil;
import com.ajaxjs.web.upload.MetaData;
import com.ajaxjs.web.upload.UploadConfig;
import com.ajaxjs.web.upload.UploadConfigImpl;
import com.ajaxjs.web.upload.UploadResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class UploadRequest
extends HttpServletRequestWrapper {
    private UploadConfig config = new UploadConfigImpl();
    private String dataStr;
    private byte[] dataBytes;

    public UploadRequest(HttpServletRequest request) {
        super(request);
    }

    private void check() throws IOException {
        if (!this.getMethod().equals("POST")) {
            throw new IllegalArgumentException("\u5fc5\u987b POST \u8bf7\u6c42");
        }
        if (this.getContentLength() > this.config.getMaxTotalFileSize()) {
            throw new IOException("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u7cfb\u7edf\u9650\u5236\uff01");
        }
        if (this.getContentType().indexOf("multipart/form-data") == -1) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u8868\u5355  multipart/form-data");
        }
    }

    private byte[] getBoundary() {
        String boundary = StringUtil.regMatch((String)"boundary=((?:-|\\w)+)$", (String)this.getContentType(), (int)1);
        return boundary.getBytes();
    }

    public UploadResult upload() throws IOException {
        this.check();
        ServletInputStream in = null;
        try {
            in = this.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dataBytes = ((StreamUtil)((StreamUtil)((StreamUtil)new StreamUtil().setIn((InputStream)in)).inputStream2Byte()).close()).getData();
        this.dataStr = Encode.byte2String((byte[])this.dataBytes);
        MetaData meta = new MetaData();
        meta.parseMeta(this.dataStr);
        int offset = MetaData.get(this.dataBytes);
        int length = this.getLength(offset);
        return this.save(offset, length, meta);
    }

    private int getLength(int start) {
        int endPos = StreamUtil.byteIndexOf((byte[])this.dataBytes, (byte[])this.getBoundary(), (int)start) - 4;
        if (start == endPos) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u8868\u5355\u4e2d\u6ca1\u6709\u4e8c\u8fdb\u5236\u6570\u636e\uff0c\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a\uff01");
        }
        int length = endPos - start;
        return length;
    }

    public int getStartPos() {
        int start = 0;
        int contentLength_index = this.dataStr.indexOf("Content-Length:");
        try {
            if (contentLength_index != -1) {
                String contentLength = this.dataStr.substring(contentLength_index);
                contentLength = contentLength.substring(0, contentLength.indexOf("\n"));
                start = StreamUtil.byteIndexOf((byte[])this.dataBytes, (byte[])contentLength.getBytes(), (int)start) + contentLength.length();
                start = StreamUtil.byteIndexOf((byte[])this.dataBytes, (byte[])"\n".getBytes(), (int)start) + 1;
                start = StreamUtil.byteIndexOf((byte[])this.dataBytes, (byte[])"\n".getBytes(), (int)start) + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("\u4f60\u7684\u8868\u5355\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u4e00\u4e2a name\uff0c\u4e0d\u80fd\u83b7\u53d6\u5b57\u6bb5");
        }
        return start;
    }

    private UploadResult save(int offset, int length, MetaData meta) {
        String fullPath = this.config.getSaveFolder() + this.config.getFileName(meta);
        File file = null;
        UploadResult result = new UploadResult();
        try {
            file = FileUtil.createFile((String)fullPath, (boolean)this.config.isFileOverwrite());
            ((FileUtil)new FileUtil().setData(this.dataBytes)).setFile(file).save(offset, length).close();
            result.fullPath = fullPath;
            result.fileName = file.getName();
            result.isOk = true;
        }
        catch (IOException e) {
            result.errMsg = e.getMessage();
            e.printStackTrace();
        }
        return result;
    }

    public UploadConfig getConfig() {
        return this.config;
    }

    public void setConfig(UploadConfig config) {
        this.config = config;
    }
}

