/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.websocket;

import com.ajaxjs.web.websocket.WsConfigurator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value="/webSocket", configurator=WsConfigurator.class)
public class Controller {
    private static final AtomicInteger onlineCount = new AtomicInteger(0);
    private static final Set<Controller> webSocketSet = new CopyOnWriteArraySet<Controller>();
    private final String nickname = "\u8bbf\u5ba2" + onlineCount.getAndIncrement();
    private Session session;

    @OnOpen
    public void onOpen(Session session, EndpointConfig config, @PathParam(value="uid") String uid) {
        this.session = session;
        webSocketSet.add(this);
        String message = String.format("[%s,%s]", this.nickname, "\u52a0\u5165\u804a\u5929\u5ba4");
        this.broadcast(message);
        System.out.println("onOpen");
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        this.broadcast(String.format("%s:%s", this.nickname, Controller.filter(message)));
    }

    @OnClose
    public void onClose() {
        webSocketSet.remove(this);
        String message = String.format("[%s,%s]", this.nickname, "\u79bb\u5f00\u4e86\u804a\u5929\u5ba4\u94fe\u63a5");
        this.broadcast(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void broadcast(String info) {
        Iterator<Controller> i$ = webSocketSet.iterator();
        while (i$.hasNext()) {
            Controller w = i$.next();
            try {
                Class<Controller> clazz = Controller.class;
                // MONITORENTER : com.ajaxjs.web.websocket.Controller.class
                w.session.getBasicRemote().sendText(info);
                // MONITOREXIT : clazz
            }
            catch (IOException e) {
                System.out.println("\u5411\u5ba2\u6237\u7aef" + w.nickname + "\u53d1\u9001\u6d88\u606f\u5931\u8d25");
                webSocketSet.remove(w);
                try {
                    w.session.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String message = String.format("[%s,%s]", w.nickname, "\u5df2\u7ecf\u65ad\u5f00\u94fe\u63a5");
                this.broadcast(message);
            }
        }
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        return message;
    }
}

