/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.datasource.WritableDataSource;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import java.net.URLDecoder;
import java.util.List;

@CommandMapping(name="setParamFlowRules", desc="set param flow rules, accept param: data={paramFlowRule Json}")
public class ModifyParamFlowRulesCommandHandler
implements CommandHandler<String> {
    private static WritableDataSource<List<ParamFlowRule>> paramFlowWds = null;
    private static final String SUCCESS_MSG = "success";
    private static final String WRITE_DS_FAILURE_MSG = "partial success (write data source failed)";

    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank((String)data)) {
            return CommandResponse.ofFailure((Throwable)new IllegalArgumentException("Bad data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
        }
        catch (Exception e) {
            RecordLog.info((String)"Decode rule data error", (Throwable)e);
            return CommandResponse.ofFailure((Throwable)e, (Object)"decode rule data error");
        }
        RecordLog.info((String)String.format("[API Server] Receiving rule change (type:parameter flow rule): %s", data), (Object[])new Object[0]);
        String result = SUCCESS_MSG;
        List flowRules = JSONArray.parseArray((String)data, ParamFlowRule.class);
        ParamFlowRuleManager.loadRules(flowRules);
        if (!this.writeToDataSource(paramFlowWds, flowRules)) {
            result = WRITE_DS_FAILURE_MSG;
        }
        return CommandResponse.ofSuccess((Object)result);
    }

    private <T> boolean writeToDataSource(WritableDataSource<T> dataSource, T value) {
        if (dataSource != null) {
            try {
                dataSource.write(value);
            }
            catch (Exception e) {
                RecordLog.warn((String)"Write data source failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static synchronized WritableDataSource<List<ParamFlowRule>> getWritableDataSource() {
        return paramFlowWds;
    }

    public static synchronized void setWritableDataSource(WritableDataSource<List<ParamFlowRule>> hotParamWds) {
        paramFlowWds = hotParamWds;
    }
}

