/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.TokenService;
import com.alibaba.csp.sentinel.cluster.client.TokenClientProvider;
import com.alibaba.csp.sentinel.cluster.server.EmbeddedClusterTokenServerProvider;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowSlot;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetric;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class ParamFlowChecker {
    static boolean passCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int count, Object ... args) {
        if (args == null) {
            return true;
        }
        int paramIdx = rule.getParamIdx();
        if (args.length <= paramIdx) {
            return true;
        }
        Object value = args[paramIdx];
        if (value == null) {
            return true;
        }
        if (rule.isClusterMode() && rule.getGrade() == 1) {
            return ParamFlowChecker.passClusterCheck(resourceWrapper, rule, count, value);
        }
        return ParamFlowChecker.passLocalCheck(resourceWrapper, rule, count, value);
    }

    private static boolean passLocalCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int count, Object value) {
        block6: {
            try {
                if (Collection.class.isAssignableFrom(value.getClass())) {
                    for (Object param : (Collection)value) {
                        if (ParamFlowChecker.passSingleValueCheck(resourceWrapper, rule, count, param)) continue;
                        return false;
                    }
                    break block6;
                }
                if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        Object param = Array.get(value, i);
                        if (ParamFlowChecker.passSingleValueCheck(resourceWrapper, rule, count, param)) continue;
                        return false;
                    }
                    break block6;
                }
                return ParamFlowChecker.passSingleValueCheck(resourceWrapper, rule, count, value);
            }
            catch (Throwable e) {
                RecordLog.warn((String)"[ParamFlowChecker] Unexpected error", (Throwable)e);
            }
        }
        return true;
    }

    static boolean passSingleValueCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int count, Object value) {
        Set<Object> exclusionItems = rule.getParsedHotItems().keySet();
        if (rule.getGrade() == 1) {
            double curCount = ParamFlowChecker.getHotParameters(resourceWrapper).getPassParamQps(rule.getParamIdx(), value);
            if (exclusionItems.contains(value)) {
                int itemQps = rule.getParsedHotItems().get(value);
                return curCount + (double)count <= (double)itemQps;
            }
            if (curCount + (double)count > rule.getCount()) {
                return curCount - rule.getCount() < 1.0 && curCount - rule.getCount() > 0.0;
            }
        } else if (rule.getGrade() == 0) {
            long threadCount = ParamFlowChecker.getHotParameters(resourceWrapper).getThreadCount(rule.getParamIdx(), value);
            if (exclusionItems.contains(value)) {
                int itemThreshold = rule.getParsedHotItems().get(value);
                return ++threadCount <= (long)itemThreshold;
            }
            long threshold = (long)rule.getCount();
            return ++threadCount <= threshold;
        }
        return true;
    }

    private static ParameterMetric getHotParameters(ResourceWrapper resourceWrapper) {
        return ParamFlowSlot.getParamMetric(resourceWrapper);
    }

    private static Collection<Object> toCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value.getClass().isArray()) {
            ArrayList<Object> params = new ArrayList<Object>();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object param = Array.get(value, i);
                params.add(param);
            }
            return params;
        }
        return Collections.singletonList(value);
    }

    private static boolean passClusterCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int count, Object value) {
        try {
            Collection<Object> params = ParamFlowChecker.toCollection(value);
            TokenService clusterService = ParamFlowChecker.pickClusterService();
            if (clusterService == null) {
                return ParamFlowChecker.fallbackToLocalOrPass(resourceWrapper, rule, count, params);
            }
            TokenResult result = clusterService.requestParamToken(rule.getClusterConfig().getFlowId(), count, params);
            switch (result.getStatus()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            return ParamFlowChecker.fallbackToLocalOrPass(resourceWrapper, rule, count, params);
        }
        catch (Throwable ex) {
            RecordLog.warn((String)"[ParamFlowChecker] Request cluster token for parameter unexpected failed", (Throwable)ex);
            return ParamFlowChecker.fallbackToLocalOrPass(resourceWrapper, rule, count, value);
        }
    }

    private static boolean fallbackToLocalOrPass(ResourceWrapper resourceWrapper, ParamFlowRule rule, int count, Object value) {
        if (rule.getClusterConfig().isFallbackToLocalWhenFail()) {
            return ParamFlowChecker.passLocalCheck(resourceWrapper, rule, count, value);
        }
        return true;
    }

    private static TokenService pickClusterService() {
        if (ClusterStateManager.isClient()) {
            return TokenClientProvider.getClient();
        }
        if (ClusterStateManager.isServer()) {
            return EmbeddedClusterTokenServerProvider.getServer();
        }
        return null;
    }

    private ParamFlowChecker() {
    }
}

