/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowClusterConfig;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParamFlowRule
extends AbstractRule {
    private int grade = 1;
    private Integer paramIdx;
    private double count;
    private List<ParamFlowItem> paramFlowItemList = new ArrayList<ParamFlowItem>();
    private Map<Object, Integer> hotItems = new HashMap<Object, Integer>();
    private boolean clusterMode = false;
    private ParamFlowClusterConfig clusterConfig;

    public ParamFlowRule() {
    }

    public ParamFlowRule(String resourceName) {
        this.setResource(resourceName);
    }

    public int getGrade() {
        return this.grade;
    }

    public ParamFlowRule setGrade(int grade) {
        this.grade = grade;
        return this;
    }

    public Integer getParamIdx() {
        return this.paramIdx;
    }

    public ParamFlowRule setParamIdx(Integer paramIdx) {
        this.paramIdx = paramIdx;
        return this;
    }

    public double getCount() {
        return this.count;
    }

    public ParamFlowRule setCount(double count) {
        this.count = count;
        return this;
    }

    public List<ParamFlowItem> getParamFlowItemList() {
        return this.paramFlowItemList;
    }

    public ParamFlowRule setParamFlowItemList(List<ParamFlowItem> paramFlowItemList) {
        this.paramFlowItemList = paramFlowItemList;
        return this;
    }

    public Integer retrieveExclusiveItemCount(Object value) {
        if (value == null || this.hotItems == null) {
            return null;
        }
        return this.hotItems.get(value);
    }

    Map<Object, Integer> getParsedHotItems() {
        return this.hotItems;
    }

    ParamFlowRule setParsedHotItems(Map<Object, Integer> hotItems) {
        this.hotItems = hotItems;
        return this;
    }

    public boolean isClusterMode() {
        return this.clusterMode;
    }

    public ParamFlowRule setClusterMode(boolean clusterMode) {
        this.clusterMode = clusterMode;
        return this;
    }

    public ParamFlowClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public ParamFlowRule setClusterConfig(ParamFlowClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
        return this;
    }

    @Deprecated
    public boolean passCheck(Context context, DefaultNode node, int count, Object ... args) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParamFlowRule rule = (ParamFlowRule)((Object)o);
        if (this.grade != rule.grade) {
            return false;
        }
        if (Double.compare(rule.count, this.count) != 0) {
            return false;
        }
        if (this.clusterMode != rule.clusterMode) {
            return false;
        }
        if (this.paramIdx != null ? !this.paramIdx.equals(rule.paramIdx) : rule.paramIdx != null) {
            return false;
        }
        if (this.paramFlowItemList != null ? !this.paramFlowItemList.equals(rule.paramFlowItemList) : rule.paramFlowItemList != null) {
            return false;
        }
        return this.clusterConfig != null ? this.clusterConfig.equals(rule.clusterConfig) : rule.clusterConfig == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.grade;
        result = 31 * result + (this.paramIdx != null ? this.paramIdx.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.count);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.paramFlowItemList != null ? this.paramFlowItemList.hashCode() : 0);
        result = 31 * result + (this.clusterMode ? 1 : 0);
        result = 31 * result + (this.clusterConfig != null ? this.clusterConfig.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ParamFlowRule{grade=" + this.grade + ", paramIdx=" + this.paramIdx + ", count=" + this.count + ", paramFlowItemList=" + this.paramFlowItemList + ", clusterMode=" + this.clusterMode + ", clusterConfig=" + this.clusterConfig + '}';
    }
}

