/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command;

public class CommandResponse<R> {
    private final boolean success;
    private final R result;
    private final Throwable exception;

    private CommandResponse(R result) {
        this(result, true, null);
    }

    private CommandResponse(R result, boolean success, Throwable exception) {
        this.success = success;
        this.result = result;
        this.exception = exception;
    }

    public static <T> CommandResponse<T> ofSuccess(T result) {
        return new CommandResponse<T>(result);
    }

    public static <T> CommandResponse<T> ofFailure(Throwable ex) {
        return new CommandResponse<Object>(null, false, ex);
    }

    public static <T> CommandResponse<T> ofFailure(Throwable ex, T result) {
        return new CommandResponse<T>(result, false, ex);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public R getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }
}

