/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.command.vo.NodeVo;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Map;

@CommandMapping(name="clusterNode", desc="get all clusterNode VO, use type=notZero to ignore those nodes with totalRequest <=0")
public class FetchSimpleClusterNodeCommandHandler
implements CommandHandler<String> {
    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String type = request.getParam("type");
        ArrayList<NodeVo> list = new ArrayList<NodeVo>();
        Map map = ClusterBuilderSlot.getClusterNodeMap();
        if (map == null) {
            return CommandResponse.ofSuccess(JSONArray.toJSONString(list));
        }
        for (Map.Entry entry : map.entrySet()) {
            if ("notZero".equalsIgnoreCase(type)) {
                if (((ClusterNode)entry.getValue()).totalRequest() <= 0L) continue;
                list.add(NodeVo.fromClusterNode((ResourceWrapper)entry.getKey(), (ClusterNode)entry.getValue()));
                continue;
            }
            list.add(NodeVo.fromClusterNode((ResourceWrapper)entry.getKey(), (ClusterNode)entry.getValue()));
        }
        return CommandResponse.ofSuccess(JSONArray.toJSONString(list));
    }
}

