/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

import java.awt.image.*;

public class BorderFilter extends ImageFilter implements java.io.Serializable {

	static final long serialVersionUID = 670926158411088373L;
	
	private int width, height;
	private int leftBorder, rightBorder;
	private int topBorder, bottomBorder;

	public BorderFilter() {
	}

	public void setLeftBorder(int leftBorder) {
		this.leftBorder = leftBorder;
	}
	
	public int getLeftBorder() {
		return leftBorder;
	}
	
	public void setRightBorder(int rightBorder) {
		this.rightBorder = rightBorder;
	}
	
	public int getRightBorder() {
		return rightBorder;
	}
	
	public void setTopBorder(int topBorder) {
		this.topBorder = topBorder;
	}

	public int getTopBorder() {
		return topBorder;
	}

	public void setBottomBorder(int bottomBorder) {
		this.bottomBorder = bottomBorder;
	}

	public int getBottomBorder() {
		return bottomBorder;
	}

    public void setHints(int hintflags) {
	    hintflags &= ~TOPDOWNLEFTRIGHT;
		consumer.setHints(hintflags);
	}

	public void setDimensions(int width, int height) {
		this.width = width;
		this.height = height;
		consumer.setDimensions(width+leftBorder+rightBorder, height+topBorder+bottomBorder);
	}

	public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
		consumer.setPixels(x+leftBorder, y+topBorder, width, height, model, pixels, 0, scansize);
	}

	public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
		consumer.setPixels(x+leftBorder, y+topBorder, width, height, model, pixels, 0, scansize);
	}

	public String toString() {
		return "Distort/Border...";
	}
}
