/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

import java.awt.*;
import java.awt.image.*;

public class PerspectivFilter extends TransformFilter {

	private float x0, y0, x1, y1, x2, y2, x3, y3;
	private float dx1, dy1, dx2, dy2, dx3, dy3;
	private float A, B, C, D, E, F, G, H, I;
	
	public PerspectivFilter() {
		this(0, 0, 100, 0, 100, 100, 0, 100);
	}
	
	public PerspectivFilter(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
		setCorners(x0, y0, x1, y1, x2, y2, x3, y3);
	}
	
	public void setCorners(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
		this.x0 = x0;
		this.y0 = y0;
		this.x1 = x1;
		this.y1 = y1;
		this.x2 = x2;
		this.y2 = y2;
		this.x3 = x3;
		this.y3 = y3;
		
		dx1 = x1-x2;
		dy1 = y1-y2;
		dx2 = x3-x2;
		dy2 = y3-y2;
		dx3 = x0-x1+x2-x3;
		dy3 = y0-y1+y2-y3;
		
		float a11, a12, a13, a21, a22, a23, a31, a32;

		if (dx3 == 0 && dy3 == 0) {
			a11 = x1-x0;
			a21 = x2-x1;
			a31 = x0;
			a12 = y1-y0;
			a22 = y2-y1;
			a32 = y0;
			a13 = a23 = 0;
		} else {
			a13=(dx3*dy2-dx2*dy3)/(dx1*dy2-dy1*dx2);
			a23=(dx1*dy3-dy1*dx3)/(dx1*dy2-dy1*dx2);
			a11=x1-x0+a13*x1;
			a21=x3-x0+a23*x3;
			a31=x0;
			a12=y1-y0+a13*y1;
			a22=y3-y0+a23*y3;
			a32=y0;
		}

	    A = a22 - a32*a23;
	    B = a31*a23 - a21;
	    C = a21*a32 - a31*a22;
	    D = a32*a13 - a12;
	    E = a11 - a31*a13;
	    F = a31*a12 - a11*a32;
	    G = a12*a23 - a22*a13;
	    H = a21*a13 - a11*a23;
	    I = a11*a22 - a21*a12;
	}

	protected void transformInverse(int x, int y, float[] out) {
		out[0] = 0.5f + originalSpace.width * (A*x+B*y+C)/(G*x+H*y+I);
		out[1] = 0.5f + originalSpace.height * (D*x+E*y+F)/(G*x+H*y+I);
	}

	public String toString() {
		return "Distort/Perspective...";
	}
}

