/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

import java.awt.image.*;
import java.util.*;

public class NoiseFilter extends RGBImageFilter implements java.io.Serializable {

	static final long serialVersionUID = 1970783813893879484L;
	
	private int amount = 25;
	private boolean gaussian = false;
	private boolean monochrome = false;
	private Random randomNumbers = new Random();
	
	public NoiseFilter() {
	}

	public void setAmount(int amount) {
		this.amount = amount;
	}
	
	public int getAmount() {
		return amount;
	}
	
	public void setGaussian(boolean gaussian) {
		this.gaussian = gaussian;
	}
	
	public boolean getGaussian() {
		return gaussian;
	}
	
	public void setMonochrome(boolean monochrome) {
		this.monochrome = monochrome;
	}
	
	public boolean getMonochrome() {
		return monochrome;
	}
	
	private int random(int x) {
		x += (int)(((gaussian ? randomNumbers.nextGaussian() : 2*randomNumbers.nextFloat() - 1)) * amount);
		if (x < 0)
			x = 0;
		else if (x > 0xff)
			x = 0xff;
		return x;
	}
	
	public int filterRGB(int x, int y, int rgb) {
		int a = rgb & 0xff000000;
		int r = (rgb >> 16) & 0xff;
		int g = (rgb >> 8) & 0xff;
		int b = rgb & 0xff;
		if (monochrome) {
			int n = (int)(((gaussian ? randomNumbers.nextGaussian() : 2*randomNumbers.nextFloat() - 1)) * amount);
			r = PixelUtils.clamp(r+n);
			g = PixelUtils.clamp(g+n);
			b = PixelUtils.clamp(b+n);
		} else {
			r = random(r);
			g = random(g);
			b = random(b);
		}
		return a | (r << 16) | (g << 8) | b;
	}

	public String toString() {
		return "Stylize/Add Noise...";
	}
}
