/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

import java.awt.image.*;

public class OffsetFilter extends ImageFilter implements java.io.Serializable {

	static final long serialVersionUID = 8123120922961090736L;
	
	private int width, height;
	private int xOffset, yOffset;
	private boolean wrap;

	public OffsetFilter() {
		this(0, 0, true);
	}

	public OffsetFilter(int xOffset, int yOffset, boolean wrap) {
		this.xOffset = xOffset;
		this.yOffset = yOffset;
		this.wrap = wrap;
	}

	public void setXOffset(int xOffset) {
		this.xOffset = xOffset;
	}
	
	public int getXOffset() {
		return xOffset;
	}
	
	public void setYOffset(int yOffset) {
		this.yOffset = yOffset;
	}
	
	public int getYOffset() {
		return yOffset;
	}
	
	public void setWrap(boolean wrap) {
		this.wrap = wrap;
	}
	
	public boolean getWrap() {
		return wrap;
	}
	
    public void setHints(int hintflags) {
	    hintflags &= ~TOPDOWNLEFTRIGHT;
		consumer.setHints(hintflags);
	}

	public void setDimensions(int width, int height) {
		this.width = width;
		this.height = height;
		while (xOffset < 0)
			xOffset += width;
		while (yOffset < 0)
			yOffset += height;
		xOffset %= width;
		yOffset %= height;
		consumer.setDimensions(width, height);
	}

	public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
		consumer.setPixels(x+xOffset, y+yOffset, width-xOffset, height-yOffset, model, pixels, 0, scansize);
		if (wrap) {
			if (x+w+xOffset > width) {
				consumer.setPixels(0, y+yOffset, xOffset-(width-x-w), height-yOffset, model, pixels, w-xOffset, scansize);
				if (y+h+yOffset > height)
					consumer.setPixels(0, 0, xOffset-(width-x-w), yOffset-(height-y-h), model, pixels, w-xOffset+(h-yOffset)*scansize, scansize);
			}
			if (y+h+yOffset > height)
				consumer.setPixels(x+xOffset, 0, width-xOffset, yOffset-(height-y-h), model, pixels, (h-yOffset)*scansize, scansize);
		}
	}

	public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
		consumer.setPixels(x+xOffset, y+yOffset, width-xOffset, height-yOffset, model, pixels, 0, scansize);
		if (wrap) {
			if (x+w+xOffset > width) {
				consumer.setPixels(0, y+yOffset, xOffset-(width-x-w), height-yOffset, model, pixels, w-xOffset, scansize);
				if (y+h+yOffset > height)
					consumer.setPixels(0, 0, xOffset-(width-x-w), yOffset-(height-y-h), model, pixels, w-xOffset+(h-yOffset)*scansize, scansize);
			}
			if (y+h+yOffset > height)
				consumer.setPixels(x+xOffset, 0, width-xOffset, yOffset-(height-y-h), model, pixels, (h-yOffset)*scansize, scansize);
		}
	}

	public String toString() {
		return "Distort/Offset...";
	}
}
