/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus;

import com.amadeus.Airport;
import com.amadeus.Booking;
import com.amadeus.Configuration;
import com.amadeus.EReputation;
import com.amadeus.HTTPClient;
import com.amadeus.Media;
import com.amadeus.ReferenceData;
import com.amadeus.Safety;
import com.amadeus.Schedule;
import com.amadeus.Shopping;
import com.amadeus.Travel;
import java.util.Map;
import lombok.NonNull;

public class Amadeus
extends HTTPClient {
    public static final String VERSION = "5.5.0";
    public ReferenceData referenceData = new ReferenceData(this);
    public Travel travel = new Travel(this);
    public Shopping shopping = new Shopping(this);
    public EReputation ereputation = new EReputation(this);
    public Airport airport = new Airport(this);
    public Booking booking = new Booking(this);
    public Media media = new Media(this);
    public Safety safety = new Safety(this);
    public Schedule schedule = new Schedule(this);

    protected Amadeus(Configuration configuration) {
        super(configuration);
    }

    public static Configuration builder(@NonNull String clientId, @NonNull String clientSecret) {
        if (clientId == null) {
            throw new NullPointerException("clientId");
        }
        if (clientSecret == null) {
            throw new NullPointerException("clientSecret");
        }
        return new Configuration(clientId, clientSecret);
    }

    public static Configuration builder(Map<String, String> environment) {
        String clientId = environment.get("AMADEUS_CLIENT_ID");
        String clientSecret = environment.get("AMADEUS_CLIENT_SECRET");
        Configuration configuration = Amadeus.builder(clientId, clientSecret);
        configuration.parseEnvironment(environment);
        return configuration;
    }
}

