/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus;

import com.amadeus.Amadeus;
import com.amadeus.Params;
import java.util.Map;
import java.util.logging.Logger;

public class Configuration {
    private static final Params HOSTS = Params.with("production", "api.amadeus.com").and("test", "test.api.amadeus.com");
    private String clientId;
    private String clientSecret;
    private Logger logger = Logger.getLogger("Amadeus");
    private String logLevel = "silent";
    private String hostname = "test";
    private String host = "test.api.amadeus.com";
    private boolean ssl = true;
    private int port = 443;
    private String customAppId;
    private String customAppVersion;

    protected Configuration(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public Amadeus build() throws NullPointerException {
        return new Amadeus(this);
    }

    public Configuration setHostname(String hostname) {
        if (!HOSTS.containsKey(hostname)) {
            throw new IllegalArgumentException(String.format("Hostname %s not found in %s", hostname, HOSTS.keySet().toString()));
        }
        this.hostname = hostname;
        this.host = (String)HOSTS.get(hostname);
        return this;
    }

    public Configuration setSsl(Boolean ssl) {
        this.ssl = ssl;
        if (!ssl.booleanValue() && this.port == 443) {
            this.setPort(80);
        }
        return this;
    }

    protected Configuration parseEnvironment(Map<String, String> environment) {
        this.setHostname(this.getOrDefault(environment, "HOSTNAME", this.hostname));
        this.setHost(this.getOrDefault(environment, "HOST", this.host));
        this.setLogLevel(this.getOrDefault(environment, "LOG_LEVEL", this.logLevel));
        this.setSsl(Boolean.parseBoolean(this.getOrDefault(environment, "SSL", String.valueOf(this.ssl))));
        this.setPort(Integer.parseInt(this.getOrDefault(environment, "PORT", String.valueOf(this.port))));
        this.setCustomAppId(this.getOrDefault(environment, "CUSTOM_APP_ID", this.customAppId));
        this.setCustomAppVersion(this.getOrDefault(environment, "CUSTOM_APP_VERSION", this.customAppVersion));
        return this;
    }

    private String getOrDefault(Map<String, String> environment, String key, String defaultValue) {
        String value = environment.get(String.format("AMADEUS_%s", key));
        return value == null ? defaultValue : value;
    }

    public String toString() {
        return "Configuration(clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", logger=" + this.getLogger() + ", logLevel=" + this.getLogLevel() + ", hostname=" + this.getHostname() + ", host=" + this.getHost() + ", ssl=" + this.isSsl() + ", port=" + this.getPort() + ", customAppId=" + this.getCustomAppId() + ", customAppVersion=" + this.getCustomAppVersion() + ")";
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Configuration setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public Configuration setLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHost() {
        return this.host;
    }

    public Configuration setHost(String host) {
        this.host = host;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public int getPort() {
        return this.port;
    }

    public Configuration setPort(int port) {
        this.port = port;
        return this;
    }

    public String getCustomAppId() {
        return this.customAppId;
    }

    public Configuration setCustomAppId(String customAppId) {
        this.customAppId = customAppId;
        return this;
    }

    public String getCustomAppVersion() {
        return this.customAppVersion;
    }

    public Configuration setCustomAppVersion(String customAppVersion) {
        this.customAppVersion = customAppVersion;
        return this;
    }
}

