/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.resources;

import com.amadeus.resources.Resource;
import java.util.Arrays;

public class DatedFlight
extends Resource {
    private String type;
    private String scheduledDepartureDate;
    private FlightDesignator flightDesignator;
    private FlightPoint[] flightPoints;
    private Segment[] segments;
    private Leg[] legs;

    protected DatedFlight() {
    }

    public String toString() {
        return "DatedFlight(type=" + this.getType() + ", scheduledDepartureDate=" + this.getScheduledDepartureDate() + ", flightDesignator=" + this.getFlightDesignator() + ", flightPoints=" + Arrays.deepToString(this.getFlightPoints()) + ", segments=" + Arrays.deepToString(this.getSegments()) + ", legs=" + Arrays.deepToString(this.getLegs()) + ")";
    }

    public String getType() {
        return this.type;
    }

    public String getScheduledDepartureDate() {
        return this.scheduledDepartureDate;
    }

    public FlightDesignator getFlightDesignator() {
        return this.flightDesignator;
    }

    public FlightPoint[] getFlightPoints() {
        return this.flightPoints;
    }

    public Segment[] getSegments() {
        return this.segments;
    }

    public Leg[] getLegs() {
        return this.legs;
    }

    public class AircraftEquipment {
        private String aircraftType;

        protected AircraftEquipment() {
        }

        public String toString() {
            return "DatedFlight.AircraftEquipment(aircraftType=" + this.getAircraftType() + ")";
        }

        public String getAircraftType() {
            return this.aircraftType;
        }
    }

    public class Leg {
        private String boardPointIataCode;
        private String offPointIataCode;
        private AircraftEquipment aircraftEquipment;
        private String scheduledLegDuration;

        protected Leg() {
        }

        public String toString() {
            return "DatedFlight.Leg(boardPointIataCode=" + this.getBoardPointIataCode() + ", offPointIataCode=" + this.getOffPointIataCode() + ", aircraftEquipment=" + this.getAircraftEquipment() + ", scheduledLegDuration=" + this.getScheduledLegDuration() + ")";
        }

        public String getBoardPointIataCode() {
            return this.boardPointIataCode;
        }

        public String getOffPointIataCode() {
            return this.offPointIataCode;
        }

        public AircraftEquipment getAircraftEquipment() {
            return this.aircraftEquipment;
        }

        public String getScheduledLegDuration() {
            return this.scheduledLegDuration;
        }
    }

    public class Partnership {
        private FlightDesignator operatingFlight;

        protected Partnership() {
        }

        public String toString() {
            return "DatedFlight.Partnership(operatingFlight=" + this.getOperatingFlight() + ")";
        }

        public FlightDesignator getOperatingFlight() {
            return this.operatingFlight;
        }
    }

    public class Segment {
        private String boardPointIataCode;
        private String offPointIataCode;
        private String scheduledSegmentDuration;
        private Partnership partnership;

        protected Segment() {
        }

        public String toString() {
            return "DatedFlight.Segment(boardPointIataCode=" + this.getBoardPointIataCode() + ", offPointIataCode=" + this.getOffPointIataCode() + ", scheduledSegmentDuration=" + this.getScheduledSegmentDuration() + ", partnership=" + this.getPartnership() + ")";
        }

        public String getBoardPointIataCode() {
            return this.boardPointIataCode;
        }

        public String getOffPointIataCode() {
            return this.offPointIataCode;
        }

        public String getScheduledSegmentDuration() {
            return this.scheduledSegmentDuration;
        }

        public Partnership getPartnership() {
            return this.partnership;
        }
    }

    public class Terminal {
        private String code;

        protected Terminal() {
        }

        public String toString() {
            return "DatedFlight.Terminal(code=" + this.getCode() + ")";
        }

        public String getCode() {
            return this.code;
        }
    }

    public class Gate {
        private String mainGate;

        protected Gate() {
        }

        public String toString() {
            return "DatedFlight.Gate(mainGate=" + this.getMainGate() + ")";
        }

        public String getMainGate() {
            return this.mainGate;
        }
    }

    public class Delay {
        private String duration;

        protected Delay() {
        }

        public String toString() {
            return "DatedFlight.Delay(duration=" + this.getDuration() + ")";
        }

        public String getDuration() {
            return this.duration;
        }
    }

    public class Timing {
        private String qualifier;
        private String value;
        private Delay delays;

        protected Timing() {
        }

        public String toString() {
            return "DatedFlight.Timing(qualifier=" + this.getQualifier() + ", value=" + this.getValue() + ", delays=" + this.getDelays() + ")";
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public String getValue() {
            return this.value;
        }

        public Delay getDelays() {
            return this.delays;
        }
    }

    public class Arrival {
        private Timing[] timings;
        private Terminal[] terminal;
        private Gate[] gate;

        protected Arrival() {
        }

        public String toString() {
            return "DatedFlight.Arrival(timings=" + Arrays.deepToString(this.getTimings()) + ", terminal=" + Arrays.deepToString(this.getTerminal()) + ", gate=" + Arrays.deepToString(this.getGate()) + ")";
        }

        public Timing[] getTimings() {
            return this.timings;
        }

        public Terminal[] getTerminal() {
            return this.terminal;
        }

        public Gate[] getGate() {
            return this.gate;
        }
    }

    public class Departure {
        private Timing[] timings;
        private Terminal[] terminal;
        private Gate[] gate;

        protected Departure() {
        }

        public String toString() {
            return "DatedFlight.Departure(timings=" + Arrays.deepToString(this.getTimings()) + ", terminal=" + Arrays.deepToString(this.getTerminal()) + ", gate=" + Arrays.deepToString(this.getGate()) + ")";
        }

        public Timing[] getTimings() {
            return this.timings;
        }

        public Terminal[] getTerminal() {
            return this.terminal;
        }

        public Gate[] getGate() {
            return this.gate;
        }
    }

    public class FlightPoint {
        private String iataCode;
        private Departure departure;
        private Arrival arrival;

        protected FlightPoint() {
        }

        public String toString() {
            return "DatedFlight.FlightPoint(iataCode=" + this.getIataCode() + ", departure=" + this.getDeparture() + ", arrival=" + this.getArrival() + ")";
        }

        public String getIataCode() {
            return this.iataCode;
        }

        public Departure getDeparture() {
            return this.departure;
        }

        public Arrival getArrival() {
            return this.arrival;
        }
    }

    public class FlightDesignator {
        private String carrierCode;
        private int flightNumber;
        private String operationalSuffix;

        protected FlightDesignator() {
        }

        public String toString() {
            return "DatedFlight.FlightDesignator(carrierCode=" + this.getCarrierCode() + ", flightNumber=" + this.getFlightNumber() + ", operationalSuffix=" + this.getOperationalSuffix() + ")";
        }

        public String getCarrierCode() {
            return this.carrierCode;
        }

        public int getFlightNumber() {
            return this.flightNumber;
        }

        public String getOperationalSuffix() {
            return this.operationalSuffix;
        }
    }
}

