/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.resources;

import com.amadeus.resources.Resource;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;

public class FlightOfferSearch
extends Resource {
    private String type;
    private String id;
    private String source;
    private boolean instantTicketingRequired;
    private boolean nonHomogeneous;
    private boolean oneWay;
    private String lastTicketingDate;
    private int numberOfBookableSeats;
    private Itinerary[] itineraries;
    private SearchPrice price;
    private PricingOptions pricingOptions;
    private String[] validatingAirlineCodes;
    private TravelerPricing[] travelerPricings;
    private String choiceProbability;

    protected FlightOfferSearch() {
    }

    public String toString() {
        return "FlightOfferSearch(type=" + this.getType() + ", id=" + this.getId() + ", source=" + this.getSource() + ", instantTicketingRequired=" + this.isInstantTicketingRequired() + ", nonHomogeneous=" + this.isNonHomogeneous() + ", oneWay=" + this.isOneWay() + ", lastTicketingDate=" + this.getLastTicketingDate() + ", numberOfBookableSeats=" + this.getNumberOfBookableSeats() + ", itineraries=" + Arrays.deepToString(this.getItineraries()) + ", price=" + this.getPrice() + ", pricingOptions=" + this.getPricingOptions() + ", validatingAirlineCodes=" + Arrays.deepToString(this.getValidatingAirlineCodes()) + ", travelerPricings=" + Arrays.deepToString(this.getTravelerPricings()) + ", choiceProbability=" + this.getChoiceProbability() + ")";
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isInstantTicketingRequired() {
        return this.instantTicketingRequired;
    }

    public boolean isNonHomogeneous() {
        return this.nonHomogeneous;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public String getLastTicketingDate() {
        return this.lastTicketingDate;
    }

    public int getNumberOfBookableSeats() {
        return this.numberOfBookableSeats;
    }

    public Itinerary[] getItineraries() {
        return this.itineraries;
    }

    public SearchPrice getPrice() {
        return this.price;
    }

    public PricingOptions getPricingOptions() {
        return this.pricingOptions;
    }

    public String[] getValidatingAirlineCodes() {
        return this.validatingAirlineCodes;
    }

    public TravelerPricing[] getTravelerPricings() {
        return this.travelerPricings;
    }

    public String getChoiceProbability() {
        return this.choiceProbability;
    }

    public class IncludedCheckedBags {
        private int weight;
        private String weightUnit;

        protected IncludedCheckedBags() {
        }

        public String toString() {
            return "FlightOfferSearch.IncludedCheckedBags(weight=" + this.getWeight() + ", weightUnit=" + this.getWeightUnit() + ")";
        }

        public int getWeight() {
            return this.weight;
        }

        public String getWeightUnit() {
            return this.weightUnit;
        }
    }

    public class FareDetailsBySegment {
        private String segmentId;
        private String cabin;
        private String fareBasis;
        @SerializedName(value="class")
        private String segmentClass;
        private IncludedCheckedBags includedCheckedBags;

        protected FareDetailsBySegment() {
        }

        public String toString() {
            return "FlightOfferSearch.FareDetailsBySegment(segmentId=" + this.getSegmentId() + ", cabin=" + this.getCabin() + ", fareBasis=" + this.getFareBasis() + ", segmentClass=" + this.getSegmentClass() + ", includedCheckedBags=" + this.getIncludedCheckedBags() + ")";
        }

        public String getSegmentId() {
            return this.segmentId;
        }

        public String getCabin() {
            return this.cabin;
        }

        public String getFareBasis() {
            return this.fareBasis;
        }

        public String getSegmentClass() {
            return this.segmentClass;
        }

        public IncludedCheckedBags getIncludedCheckedBags() {
            return this.includedCheckedBags;
        }
    }

    public class TravelerPricing {
        private String travelerId;
        private String fareOption;
        private String travelerType;
        private SearchPrice price;
        private FareDetailsBySegment[] fareDetailsBySegment;

        protected TravelerPricing() {
        }

        public String toString() {
            return "FlightOfferSearch.TravelerPricing(travelerId=" + this.getTravelerId() + ", fareOption=" + this.getFareOption() + ", travelerType=" + this.getTravelerType() + ", price=" + this.getPrice() + ", fareDetailsBySegment=" + Arrays.deepToString(this.getFareDetailsBySegment()) + ")";
        }

        public String getTravelerId() {
            return this.travelerId;
        }

        public String getFareOption() {
            return this.fareOption;
        }

        public String getTravelerType() {
            return this.travelerType;
        }

        public SearchPrice getPrice() {
            return this.price;
        }

        public FareDetailsBySegment[] getFareDetailsBySegment() {
            return this.fareDetailsBySegment;
        }
    }

    public class PricingOptions {
        private boolean includedCheckedBagsOnly;
        private String[] fareType;
        private String[] corporateCodes;
        private boolean refundableFare;
        private boolean noRestrictionFare;
        private boolean noPenaltyFare;

        public String toString() {
            return "FlightOfferSearch.PricingOptions(includedCheckedBagsOnly=" + this.isIncludedCheckedBagsOnly() + ", fareType=" + Arrays.deepToString(this.getFareType()) + ", corporateCodes=" + Arrays.deepToString(this.getCorporateCodes()) + ", refundableFare=" + this.isRefundableFare() + ", noRestrictionFare=" + this.isNoRestrictionFare() + ", noPenaltyFare=" + this.isNoPenaltyFare() + ")";
        }

        public boolean isIncludedCheckedBagsOnly() {
            return this.includedCheckedBagsOnly;
        }

        public String[] getFareType() {
            return this.fareType;
        }

        public String[] getCorporateCodes() {
            return this.corporateCodes;
        }

        public boolean isRefundableFare() {
            return this.refundableFare;
        }

        public boolean isNoRestrictionFare() {
            return this.noRestrictionFare;
        }

        public boolean isNoPenaltyFare() {
            return this.noPenaltyFare;
        }
    }

    public class Fee {
        private double amount;
        private String type;

        protected Fee() {
        }

        public String toString() {
            return "FlightOfferSearch.Fee(amount=" + this.getAmount() + ", type=" + this.getType() + ")";
        }

        public double getAmount() {
            return this.amount;
        }

        public String getType() {
            return this.type;
        }
    }

    public class SearchPrice {
        private String currency;
        private double total;
        private double base;
        private Fee[] fees;
        private double grandTotal;

        protected SearchPrice() {
        }

        public String toString() {
            return "FlightOfferSearch.SearchPrice(currency=" + this.getCurrency() + ", total=" + this.getTotal() + ", base=" + this.getBase() + ", fees=" + Arrays.deepToString(this.getFees()) + ", grandTotal=" + this.getGrandTotal() + ")";
        }

        public String getCurrency() {
            return this.currency;
        }

        public double getTotal() {
            return this.total;
        }

        public double getBase() {
            return this.base;
        }

        public Fee[] getFees() {
            return this.fees;
        }

        public double getGrandTotal() {
            return this.grandTotal;
        }
    }

    public class Aircraft {
        private String code;

        protected Aircraft() {
        }

        public String toString() {
            return "FlightOfferSearch.Aircraft(code=" + this.getCode() + ")";
        }

        public String getCode() {
            return this.code;
        }
    }

    public class AirportInfo {
        private String iataCode;
        private String terminal;
        private String at;

        protected AirportInfo() {
        }

        public String toString() {
            return "FlightOfferSearch.AirportInfo(iataCode=" + this.getIataCode() + ", terminal=" + this.getTerminal() + ", at=" + this.getAt() + ")";
        }

        public String getIataCode() {
            return this.iataCode;
        }

        public String getTerminal() {
            return this.terminal;
        }

        public String getAt() {
            return this.at;
        }
    }

    public class Co2Emissions {
        private int weight;
        private String weightUnit;
        private String cabin;

        protected Co2Emissions() {
        }

        public String toString() {
            return "FlightOfferSearch.Co2Emissions(weight=" + this.getWeight() + ", weightUnit=" + this.getWeightUnit() + ", cabin=" + this.getCabin() + ")";
        }

        public int getWeight() {
            return this.weight;
        }

        public String getWeightUnit() {
            return this.weightUnit;
        }

        public String getCabin() {
            return this.cabin;
        }
    }

    public class SearchSegment {
        private AirportInfo departure;
        private AirportInfo arrival;
        private String carrierCode;
        private String number;
        private Aircraft aircraft;
        private String duration;
        private String id;
        private int numberOfStops;
        private boolean blacklistedInEU;
        private Co2Emissions[] co2Emissions;

        protected SearchSegment() {
        }

        public String toString() {
            return "FlightOfferSearch.SearchSegment(departure=" + this.getDeparture() + ", arrival=" + this.getArrival() + ", carrierCode=" + this.getCarrierCode() + ", number=" + this.getNumber() + ", aircraft=" + this.getAircraft() + ", duration=" + this.getDuration() + ", id=" + this.getId() + ", numberOfStops=" + this.getNumberOfStops() + ", blacklistedInEU=" + this.isBlacklistedInEU() + ", co2Emissions=" + Arrays.deepToString(this.getCo2Emissions()) + ")";
        }

        public AirportInfo getDeparture() {
            return this.departure;
        }

        public AirportInfo getArrival() {
            return this.arrival;
        }

        public String getCarrierCode() {
            return this.carrierCode;
        }

        public String getNumber() {
            return this.number;
        }

        public Aircraft getAircraft() {
            return this.aircraft;
        }

        public String getDuration() {
            return this.duration;
        }

        public String getId() {
            return this.id;
        }

        public int getNumberOfStops() {
            return this.numberOfStops;
        }

        public boolean isBlacklistedInEU() {
            return this.blacklistedInEU;
        }

        public Co2Emissions[] getCo2Emissions() {
            return this.co2Emissions;
        }
    }

    public class Itinerary {
        private String duration;
        private SearchSegment[] segments;

        protected Itinerary() {
        }

        public String toString() {
            return "FlightOfferSearch.Itinerary(duration=" + this.getDuration() + ", segments=" + Arrays.deepToString(this.getSegments()) + ")";
        }

        public String getDuration() {
            return this.duration;
        }

        public SearchSegment[] getSegments() {
            return this.segments;
        }
    }
}

