/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.shopping.flightOffers;

import com.amadeus.Amadeus;
import com.amadeus.Params;
import com.amadeus.Response;
import com.amadeus.exceptions.ResponseException;
import com.amadeus.resources.FlightOfferSearch;
import com.amadeus.resources.FlightPayment;
import com.amadeus.resources.FlightPrice;
import com.amadeus.resources.Resource;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class Pricing {
    private Amadeus client;

    public Pricing(Amadeus client) {
        this.client = client;
    }

    private JsonArray buildFlightOffersJSON(FlightOfferSearch[] flightOffersSearches) {
        Gson gson = new GsonBuilder().create();
        JsonArray flightOffersArray = new JsonArray();
        for (int i = 0; i < flightOffersSearches.length; ++i) {
            JsonElement flightOffer = gson.toJsonTree((Object)flightOffersSearches[i], FlightOfferSearch.class);
            flightOffersArray.add(flightOffer);
        }
        return flightOffersArray;
    }

    private JsonArray buildPaymentJSON(FlightPayment flightPayment) {
        Gson gson = new GsonBuilder().create();
        JsonArray paymentArray = new JsonArray();
        JsonElement payment = gson.toJsonTree((Object)flightPayment, FlightPayment.class);
        paymentArray.add(payment);
        return paymentArray;
    }

    public FlightPrice post(JsonObject body, Params params) throws ResponseException {
        Response response = this.client.post("/v1/shopping/flight-offers/pricing", params, body);
        return (FlightPrice)Resource.fromObject(response, FlightPrice.class);
    }

    public FlightPrice post(String body, Params params) throws ResponseException {
        Response response = this.client.post("/v1/shopping/flight-offers/pricing", params, body);
        return (FlightPrice)Resource.fromObject(response, FlightPrice.class);
    }

    public FlightPrice post(JsonObject body) throws ResponseException {
        Response response = this.client.post("/v1/shopping/flight-offers/pricing", body);
        return (FlightPrice)Resource.fromObject(response, FlightPrice.class);
    }

    public FlightPrice post(String body) throws ResponseException {
        Response response = this.client.post("/v1/shopping/flight-offers/pricing", body);
        return (FlightPrice)Resource.fromObject(response, FlightPrice.class);
    }

    public FlightPrice post(FlightOfferSearch[] flightOffersSearches) throws ResponseException {
        return this.post(flightOffersSearches, (Params)null);
    }

    public FlightPrice post(FlightOfferSearch flightOffersSearch) throws ResponseException {
        FlightOfferSearch[] flightOffersSearchArray = new FlightOfferSearch[]{flightOffersSearch};
        return this.post(flightOffersSearchArray);
    }

    public FlightPrice post(FlightOfferSearch[] flightOffersSearches, Params params) throws ResponseException {
        JsonObject typeObject = new JsonObject();
        typeObject.addProperty("type", "flight-offers-pricing");
        JsonArray flightOffersArray = this.buildFlightOffersJSON(flightOffersSearches);
        typeObject.add("flightOffers", (JsonElement)flightOffersArray);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("data", (JsonElement)typeObject);
        Response response = params != null ? this.client.post("/v1/shopping/flight-offers/pricing", params, jsonObject) : this.client.post("/v1/shopping/flight-offers/pricing", jsonObject);
        return (FlightPrice)Resource.fromObject(response, FlightPrice.class);
    }

    public FlightPrice post(FlightOfferSearch flightOffersSearch, Params params) throws ResponseException {
        FlightOfferSearch[] flightOffersSearchArray = new FlightOfferSearch[]{flightOffersSearch};
        return this.post(flightOffersSearchArray, params);
    }

    public FlightPrice post(FlightOfferSearch[] flightOffersSearches, FlightPayment flightPayment) throws ResponseException {
        JsonObject typeObject = new JsonObject();
        typeObject.addProperty("type", "flight-offers-pricing");
        typeObject.add("payment", (JsonElement)this.buildPaymentJSON(flightPayment));
        JsonArray flightOffersArray = this.buildFlightOffersJSON(flightOffersSearches);
        typeObject.add("flightOffers", (JsonElement)flightOffersArray);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("data", (JsonElement)typeObject);
        Response response = this.client.post("/v1/shopping/flight-offers/pricing", jsonObject);
        return (FlightPrice)Resource.fromObject(response, FlightPrice.class);
    }

    public FlightPrice post(FlightOfferSearch flightOffersSearch, FlightPayment flightPayment) throws ResponseException {
        FlightOfferSearch[] flightOffersSearchArray = new FlightOfferSearch[]{flightOffersSearch};
        return this.post(flightOffersSearchArray, flightPayment);
    }

    public FlightPrice post() throws ResponseException {
        return this.post((String)null);
    }
}

