/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications.interfaces;

import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public abstract class AbstractInboundMessage
implements IInboundMessage {
    protected byte[] getNullTerminatedField(ByteBuffer buffer) {
        int startPos = buffer.position();
        while (buffer.get() != 0 && buffer.hasRemaining()) {
        }
        int length = buffer.position() - startPos - 1;
        byte[] field = new byte[length];
        buffer.position(startPos);
        buffer.get(field, 0, length);
        buffer.position(startPos + length + 1);
        return field;
    }

    protected String getNullTerminatedFieldAsUTF8String(ByteBuffer buffer) {
        byte[] nullTerminatedField = this.getNullTerminatedField(buffer);
        try {
            return new String(nullTerminatedField, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return new String(nullTerminatedField);
        }
    }
}

