/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class ErrorResponse
extends AbstractInboundMessage
implements PGConstants {
    public static final char ERROR_NOTICE_MESSAGE_FIELD_SEVERITY = 'S';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_CODE = 'C';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_MESSAGE = 'M';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_DETAIL = 'D';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_HINT = 'H';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_POSITION = 'P';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_INTERNAL_POSITION = 'p';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_INTERNAL_QUERY = 'q';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_WHERE = 'W';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_SCHEMA_NAME = 's';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_TABLE_NAME = 't';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_COLUMN_NAME = 'c';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_DATA_TYPE_NAME = 'd';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_CONSTRAINT_NAME = 'n';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_FILE = 'F';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_LINE = 'L';
    public static final char ERROR_NOTICE_MESSAGE_FIELD_ROUTINE = 'R';
    public static final String SUCCESSFUL_COMPLETION = "0";
    public static final String CLASS_01_WARNING = "1000";
    public static final String CLASS_01_WARNING_DYNAMIC_RESULT_SETS_RETURNED = "0100C";
    public static final String CLASS_01_WARNING_IMPLICIT_ZERO_BIT_PADDING = "1008";
    public static final String CLASS_01_WARNING_NULL_VALUE_ELIMINATED_IN_SET_FUNCTION = "1003";
    public static final String CLASS_01_WARNING_PRIVILEGE_NOT_GRANTED = "1007";
    public static final String CLASS_01_WARNING_PRIVILEGE_NOT_REVOKED = "1006";
    public static final String CLASS_01_WARNING_STRING_DATA_RIGHT_TRUNCATION = "1004";
    public static final String CLASS_01_WARNING_DEPRECATED_FEATURE = "01P01";
    public static final String CLASS_02_NO_DATA = "2000";
    public static final String CLASS_02_NO_DATA_NO_ADDITIONAL_DYNAMIC_RESULT_SETS_RETURNED = "2001";
    public static final String CLASS_03_SQL_STATEMENT_NOT_YET_COMPLETE = "3000";
    public static final String CLASS_08_CONNECTION_EXCEPTION = "8000";
    public static final String CLASS_08_CONNECTION_EXCEPTION_CONNECTION_DOES_NOT_EXIST = "8003";
    public static final String CLASS_08_CONNECTION_EXCEPTION_CONNECTION_FAILURE = "8006";
    public static final String CLASS_08_CONNECTION_EXCEPTION_SQLCLIENT_UNABLE_TO_ESTABLISH_SQLCONNECTION = "8001";
    public static final String CLASS_08_CONNECTION_EXCEPTION_SQLSERVER_REJECTED_ESTABLISHMENT_OF_SQLCONNECTION = "8004";
    public static final String CLASS_08_CONNECTION_EXCEPTION_TRANSACTION_RESOLUTION_UNKNOWN = "8007";
    public static final String CLASS_08_CONNECTION_EXCEPTION_PROTOCOL_VIOLATION = "08P01";
    public static final String CLASS_09_TRIGGERED_ACTION_EXCEPTION = "9000";
    public static final String CLASS_0A_FEATURE_NOT_SUPPORTED = "0A000";
    public static final String CLASS_0B_INVALID_TRANSACTION_INITIATION = "0B000";
    public static final String CLASS_0F_LOCATOR_EXCEPTION = "0F000";
    public static final String CLASS_0F_LOCATOR_EXCEPTION_INVALID_LOCATOR_SPECIFICATION = "0F001";
    public static final String CLASS_0L_INVALID_GRANTOR = "0L000";
    public static final String CLASS_0L_INVALID_GRANTOR_INVALID_GRANT_OPERATION = "0LP01";
    public static final String CLASS_0P_INVALID_ROLE_SPECIFICATION = "0P000";
    public static final String CLASS_0Z_DIAGNOSTICS_EXCEPTION = "0Z000";
    public static final String CLASS_0Z_STACKED_DIAGNOSTICS_ACCESSED_WITHOUT_ACTIVE_HANDLER = "0Z002";
    public static final String CLASS_20_CASE_NOT_FOUND = "20000";
    public static final String CLASS_21_CARDINALITY_VIOLATION = "21000";
    public static final String CLASS_22_DATA_EXCEPTION = "22000";
    public static final String CLASS_22_DATA_EXCEPTION_ARRAY_SUBSCRIPT_ERROR = "2202E";
    public static final String CLASS_22_DATA_EXCEPTION_CHARACTER_NOT_IN_REPERTOIRE = "22021";
    public static final String CLASS_22_DATA_EXCEPTION_DATETIME_FIELD_OVERFLOW = "22008";
    public static final String CLASS_22_DATA_EXCEPTION_DIVISION_BY_ZERO = "22012";
    public static final String CLASS_22_DATA_EXCEPTION_ERROR_IN_ASSIGNMENT = "22005";
    public static final String CLASS_22_DATA_EXCEPTION_ESCAPE_CHARACTER_CONFLICT = "2200B";
    public static final String CLASS_22_DATA_EXCEPTION_INDICATOR_OVERFLOW = "22022";
    public static final String CLASS_22_DATA_EXCEPTION_INTERVAL_FIELD_OVERFLOW = "22015";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_LOGARITHM = "2201E";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_NTILE_FUNCTION = "22014";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_NTH_VALUE_FUNCTION = "22016";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_POWER_FUNCTION = "2201F";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION = "2201G";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_CHARACTER_VALUE_FOR_CAST = "22018";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_DATETIME_FORMAT = "22007";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_ESCAPE_CHARACTER = "22019";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_ESCAPE_OCTET = "2200D";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_ESCAPE_SEQUENCE = "22025";
    public static final String CLASS_22_DATA_EXCEPTION_NONSTANDARD_USE_OF_ESCAPE_CHARACTER = "22P06";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_INDICATOR_PARAMETER_VALUE = "22010";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_PARAMETER_VALUE = "22023";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_REGULAR_EXPRESSION = "2201B";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_ROW_COUNT_IN_LIMIT_CLAUSE = "2201W";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_ROW_COUNT_IN_RESULT_OFFSET_CLAUSE = "2201X";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_TIME_ZONE_DISPLACEMENT_VALUE = "22009";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_USE_OF_ESCAPE_CHARACTER = "2200C";
    public static final String CLASS_22_DATA_EXCEPTION_MOST_SPECIFIC_TYPE_MISMATCH = "2200G";
    public static final String CLASS_22_DATA_EXCEPTION_NULL_VALUE_NOT_ALLOWED = "22004";
    public static final String CLASS_22_DATA_EXCEPTION_NULL_VALUE_NO_INDICATOR_PARAMETER = "22002";
    public static final String CLASS_22_DATA_EXCEPTION_NUMERIC_VALUE_OUT_OF_RANGE = "22003";
    public static final String CLASS_22_DATA_EXCEPTION_STRING_DATA_LENGTH_MISMATCH = "22026";
    public static final String CLASS_22_DATA_EXCEPTION_STRING_DATA_RIGHT_TRUNCATION = "22001";
    public static final String CLASS_22_DATA_EXCEPTION_SUBSTRING_ERROR = "22011";
    public static final String CLASS_22_DATA_EXCEPTION_TRIM_ERROR = "22027";
    public static final String CLASS_22_DATA_EXCEPTION_UNTERMINATED_C_STRING = "22024";
    public static final String CLASS_22_DATA_EXCEPTION_ZERO_LENGTH_CHARACTER_STRING = "2200F";
    public static final String CLASS_22_DATA_EXCEPTION_FLOATING_POINT_EXCEPTION = "22P01";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_TEXT_REPRESENTATION = "22P02";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_BINARY_REPRESENTATION = "22P03";
    public static final String CLASS_22_DATA_EXCEPTION_BAD_COPY_FILE_FORMAT = "22P04";
    public static final String CLASS_22_DATA_EXCEPTION_UNTRANSLATABLE_CHARACTER = "22P05";
    public static final String CLASS_22_DATA_EXCEPTION_NOT_AN_XML_DOCUMENT = "2200L";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_XML_DOCUMENT = "2200M";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_XML_CONTENT = "2200N";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_XML_COMMENT = "2200S";
    public static final String CLASS_22_DATA_EXCEPTION_INVALID_XML_PROCESSING_INSTRUCTION = "2200T";
    public static final String CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION = "23000";
    public static final String CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_RESTRICT_VIOLATION = "23001";
    public static final String CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_NOT_NULL_VIOLATION = "23502";
    public static final String CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_FOREIGN_KEY_VIOLATION = "23503";
    public static final String CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_UNIQUE_VIOLATION = "23505";
    public static final String CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_CHECK_VIOLATION = "23514";
    public static final String CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_EXCLUSION_VIOLATION = "23P01";
    public static final String CLASS_24_INVALID_CURSOR_STATE = "24000";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE = "25000";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE_ACTIVE_SQL_TRANSACTION = "25001";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE_BRANCH_TRANSACTION_ALREADY_ACTIVE = "25002";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE_HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL = "25008";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE_INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION = "25003";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE_INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION = "25004";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE_NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION = "25005";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE_READ_ONLY_SQL_TRANSACTION = "25006";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE_SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED = "25007";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE_NO_ACTIVE_SQL_TRANSACTION = "25P01";
    public static final String CLASS_25_INVALID_TRANSACTION_STATE_IN_FAILED_SQL_TRANSACTION = "25P02";
    public static final String CLASS_26_INVALID_SQL_STATEMENT_NAME = "26000";
    public static final String CLASS_27_TRIGGERED_DATA_CHANGE_VIOLATION = "27000";
    public static final String CLASS_28_INVALID_AUTHORIZATION_SPECIFICATION = "28000";
    public static final String CLASS_28_INVALID_AUTHORIZATION_SPECIFICATION_INVALID_PASSWORD = "28P01";
    public static final String CLASS_2B_DEPENDENT_PRIVILEGE_DESCRIPTORS_STILL_EXIST = "2B000";
    public static final String CLASS_2B_DEPENDENT_PRIVILEGE_DESCRIPTORS_STILL_EXIST_DEPENDENT_OBJECTS_STILL_EXIST = "2BP01";
    public static final String CLASS_2D_INVALID_TRANSACTION_TERMINATION = "2D000";
    public static final String CLASS_2F_SQL_ROUTINE_EXCEPTION = "2F000";
    public static final String CLASS_2F_SQL_ROUTINE_EXCEPTION_FUNCTION_EXECUTED_NO_RETURN_STATEMENT = "2F005";
    public static final String CLASS_2F_SQL_ROUTINE_EXCEPTION_MODIFYING_SQL_DATA_NOT_PERMITTED = "2F002";
    public static final String CLASS_2F_SQL_ROUTINE_EXCEPTION_PROHIBITED_SQL_STATEMENT_ATTEMPTED = "2F003";
    public static final String CLASS_2F_SQL_ROUTINE_EXCEPTION_READING_SQL_DATA_NOT_PERMITTED = "2F004";
    public static final String CLASS_34_INVALID_CURSOR_NAME = "34000";
    public static final String CLASS_38_EXTERNAL_ROUTINE_EXCEPTION = "38000";
    public static final String CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_CONTAINING_SQL_NOT_PERMITTED = "38001";
    public static final String CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_MODIFYING_SQL_DATA_NOT_PERMITTED = "38002";
    public static final String CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_PROHIBITED_SQL_STATEMENT_ATTEMPTED = "38003";
    public static final String CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_READING_SQL_DATA_NOT_PERMITTED = "38004";
    public static final String CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION = "39000";
    public static final String CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_INVALID_SQLSTATE_RETURNED = "39001";
    public static final String CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_NULL_VALUE_NOT_ALLOWED = "39004";
    public static final String CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_TRIGGER_PROTOCOL_VIOLATED = "39P01";
    public static final String CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_SRF_PROTOCOL_VIOLATED = "39P02";
    public static final String CLASS_3B_SAVEPOINT_EXCEPTION = "3B000";
    public static final String CLASS_3B_SAVEPOINT_EXCEPTION_INVALID_SAVEPOINT_SPECIFICATION = "3B001";
    public static final String CLASS_3D_INVALID_CATALOG_NAME = "3D000";
    public static final String CLASS_3F_INVALID_SCHEMA_NAME = "3F000";
    public static final String CLASS_40_TRANSACTION_ROLLBACK = "40000";
    public static final String CLASS_40_TRANSACTION_ROLLBACK_TRANSACTION_INTEGRITY_CONSTRAINT_VIOLATION = "40002";
    public static final String CLASS_40_TRANSACTION_ROLLBACK_SERIALIZATION_FAILURE = "40001";
    public static final String CLASS_40_TRANSACTION_ROLLBACK_STATEMENT_COMPLETION_UNKNOWN = "40003";
    public static final String CLASS_40_TRANSACTION_ROLLBACK_DEADLOCK_DETECTED = "40P01";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION = "42000";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_SYNTAX_ERROR = "42601";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INSUFFICIENT_PRIVILEGE = "42501";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_CANNOT_COERCE = "42846";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_GROUPING_ERROR = "42803";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_WINDOWING_ERROR = "42P20";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_RECURSION = "42P19";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_FOREIGN_KEY = "42830";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_NAME = "42602";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_NAME_TOO_LONG = "42622";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_RESERVED_NAME = "42939";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DATATYPE_MISMATCH = "42804";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INDETERMINATE_DATATYPE = "42P18";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_COLLATION_MISMATCH = "42P21";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INDETERMINATE_COLLATION = "42P22";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_WRONG_OBJECT_TYPE = "42809";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_COLUMN = "42703";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_FUNCTION = "42883";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_TABLE = "42P01";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_PARAMETER = "42P02";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_OBJECT = "42704";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_COLUMN = "42701";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_CURSOR = "42P03";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_DATABASE = "42P04";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_FUNCTION = "42723";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_PREPARED_STATEMENT = "42P05";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_SCHEMA = "42P06";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_TABLE = "42P07";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_ALIAS = "42712";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_OBJECT = "42710";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_COLUMN = "42702";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_FUNCTION = "42725";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_PARAMETER = "42P08";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_ALIAS = "42P09";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_COLUMN_REFERENCE = "42P10";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_COLUMN_DEFINITION = "42611";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_CURSOR_DEFINITION = "42P11";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_DATABASE_DEFINITION = "42P12";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_FUNCTION_DEFINITION = "42P13";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_PREPARED_STATEMENT_DEFINITION = "42P14";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_SCHEMA_DEFINITION = "42P15";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_TABLE_DEFINITION = "42P16";
    public static final String CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_OBJECT_DEFINITION = "42P17";
    public static final String CLASS_44_WITH_CHECK_OPTION_VIOLATION = "44000";
    public static final String CLASS_53_INSUFFICIENT_RESOURCES = "53000";
    public static final String CLASS_53_INSUFFICIENT_RESOURCES_DISK_FULL = "53100";
    public static final String CLASS_53_INSUFFICIENT_RESOURCES_OUT_OF_MEMORY = "53200";
    public static final String CLASS_53_INSUFFICIENT_RESOURCES_TOO_MANY_CONNECTIONS = "53300";
    public static final String CLASS_53_INSUFFICIENT_RESOURCES_CONFIGURATION_LIMIT_EXCEEDED = "53400";
    public static final String CLASS_54_PROGRAM_LIMIT_EXCEEDED = "54000";
    public static final String CLASS_54_PROGRAM_LIMIT_EXCEEDED_STATEMENT_TOO_COMPLEX = "54001";
    public static final String CLASS_54_PROGRAM_LIMIT_EXCEEDED_TOO_MANY_COLUMNS = "54011";
    public static final String CLASS_54_PROGRAM_LIMIT_EXCEEDED_TOO_MANY_ARGUMENTS = "54023";
    public static final String CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE = "55000";
    public static final String CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE_OBJECT_IN_USE = "55006";
    public static final String CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE_CANT_CHANGE_RUNTIME_PARAM = "55P02";
    public static final String CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE_LOCK_NOT_AVAILABLE = "55P03";
    public static final String CLASS_57_OPERATOR_INTERVENTION = "57000";
    public static final String CLASS_57_OPERATOR_INTERVENTION_QUERY_CANCELED = "57014";
    public static final String CLASS_57_OPERATOR_INTERVENTION_ADMIN_SHUTDOWN = "57P01";
    public static final String CLASS_57_OPERATOR_INTERVENTION_CRASH_SHUTDOWN = "57P02";
    public static final String CLASS_57_OPERATOR_INTERVENTION_CANNOT_CONNECT_NOW = "57P03";
    public static final String CLASS_57_OPERATOR_INTERVENTION_DATABASE_DROPPED = "57P04";
    public static final String CLASS_58_SYSTEM_ERROR = "58000";
    public static final String CLASS_58_SYSTEM_ERROR_IO_ERROR = "58030";
    public static final String CLASS_58_SYSTEM_ERROR_UNDEFINED_FILE = "58P01";
    public static final String CLASS_58_SYSTEM_ERROR_DUPLICATE_FILE = "58P02";
    public static final String CLASS_F0_CONFIG_FILE_ERROR = "F0000";
    public static final String CLASS_F0_CONFIG_FILE_ERROR_LOCK_FILE_EXISTS = "F0001";
    public static final String CLASS_HV_FDW_ERROR = "HV000";
    public static final String CLASS_HV_FDW_ERROR_FDW_COLUMN_NAME_NOT_FOUND = "HV005";
    public static final String CLASS_HV_FDW_ERROR_FDW_DYNAMIC_PARAMETER_VALUE_NEEDED = "HV002";
    public static final String CLASS_HV_FDW_ERROR_FDW_FUNCTION_SEQUENCE_ERROR = "HV010";
    public static final String CLASS_HV_FDW_ERROR_FDW_INCONSISTENT_DESCRIPTOR_INFORMATION = "HV021";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_ATTRIBUTE_VALUE = "HV024";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_COLUMN_NAME = "HV007";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_COLUMN_NUMBER = "HV008";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_DATA_TYPE = "HV004";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_DATA_TYPE_DESCRIPTORS = "HV006";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_DESCRIPTOR_FIELD_IDENTIFIER = "HV091";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_HANDLE = "HV00B";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_OPTION_INDEX = "HV00C";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_OPTION_NAME = "HV00D";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_STRING_LENGTH_OR_BUFFER_LENGTH = "HV090";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_STRING_FORMAT = "HV00A";
    public static final String CLASS_HV_FDW_ERROR_FDW_INVALID_USE_OF_NULL_POINTER = "HV009";
    public static final String CLASS_HV_FDW_ERROR_FDW_TOO_MANY_HANDLES = "HV014";
    public static final String CLASS_HV_FDW_ERROR_FDW_OUT_OF_MEMORY = "HV001";
    public static final String CLASS_HV_FDW_ERROR_FDW_NO_SCHEMAS = "HV00P";
    public static final String CLASS_HV_FDW_ERROR_FDW_OPTION_NAME_NOT_FOUND = "HV00J";
    public static final String CLASS_HV_FDW_ERROR_FDW_REPLY_HANDLE = "HV00K";
    public static final String CLASS_HV_FDW_ERROR_FDW_SCHEMA_NOT_FOUND = "HV00Q";
    public static final String CLASS_HV_FDW_ERROR_FDW_TABLE_NOT_FOUND = "HV00R";
    public static final String CLASS_HV_FDW_ERROR_FDW_UNABLE_TO_CREATE_EXECUTION = "HV00L";
    public static final String CLASS_HV_FDW_ERROR_FDW_UNABLE_TO_CREATE_REPLY = "HV00M";
    public static final String CLASS_HV_FDW_ERROR_FDW_UNABLE_TO_ESTABLISH_CONNECTION = "HV00N";
    public static final String CLASS_P0_PLPGSQL_ERROR = "P0000";
    public static final String CLASS_P0_PLPGSQL_ERROR_RAISE_EXCEPTION = "P0001";
    public static final String CLASS_P0_PLPGSQL_ERROR_NO_DATA_FOUND = "P0002";
    public static final String CLASS_P0_PLPGSQL_ERROR_TOO_MANY_ROWS = "P0003";
    public static final String CLASS_XX_INTERNAL_ERROR = "XX000";
    public static final String CLASS_XX_INTERNAL_ERROR_DATA_CORRUPTED = "XX001";
    public static final String CLASS_XX_INTERNAL_ERROR_INDEX_CORRUPTED = "XX002";
    private static final Map<String, WarningCode> m_warningCodeMap;
    private static final Map<String, ExceptionType> m_exceptionTypeMap;
    private static final ResourceBundle SEVERITY_TRANSLATION_BUNDLE;
    private Severity translatedSeverity;
    private String severity = null;
    private String code = null;
    private String message = null;
    private String detail = null;
    private String hint = null;
    private String position = null;
    private String internalPosition = null;
    private String internalQuery = null;
    private String where = null;
    private String schemaName = null;
    private String tableName = null;
    private String columnName = null;
    private String dataTypeName = null;
    private String constraintName = null;
    private String file = null;
    private String line = null;
    private String routine = null;

    public ErrorResponse(ByteBuffer buffer, int length, IPGLogger logger) {
        int beginPosition = buffer.position();
        while (buffer.hasRemaining() && buffer.position() < beginPosition + length - 4) {
            char field = (char)buffer.get();
            switch (field) {
                case 'S': {
                    this.severity = this.getNullTerminatedFieldAsUTF8String(buffer);
                    this.translatedSeverity = Severity.valueOf(SEVERITY_TRANSLATION_BUNDLE.getString(this.severity));
                    break;
                }
                case 'C': {
                    this.code = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'M': {
                    this.message = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'D': {
                    this.detail = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'H': {
                    this.hint = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'P': {
                    this.position = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'p': {
                    this.internalPosition = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'q': {
                    this.internalQuery = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'W': {
                    this.where = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 's': {
                    this.schemaName = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 't': {
                    this.tableName = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'c': {
                    this.columnName = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'd': {
                    this.dataTypeName = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'n': {
                    this.constraintName = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'F': {
                    this.file = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'L': {
                    this.line = this.getNullTerminatedFieldAsUTF8String(buffer);
                    break;
                }
                case 'R': {
                    this.routine = this.getNullTerminatedFieldAsUTF8String(buffer);
                }
            }
        }
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public Severity getTranslateSeverity() {
        return this.translatedSeverity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getHint() {
        return this.hint;
    }

    public String getPosition() {
        return this.position;
    }

    public String getInternalPosition() {
        return this.internalPosition;
    }

    public String getInternalQuery() {
        return this.internalQuery;
    }

    public String getWhere() {
        return this.where;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getFile() {
        return this.file;
    }

    public String getLine() {
        return this.line;
    }

    public String getRoutine() {
        return this.routine;
    }

    public ErrorException toErrorException() {
        String[] arguments = new String[]{this.buildErrorMessage()};
        ExceptionType exceptionType = m_exceptionTypeMap.get(this.code);
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createCustomException(this.code, PGJDBCMessageKey.PG_GENERAL_ERR.name(), arguments, exceptionType);
        return errorException;
    }

    public Warning toWarning() {
        WarningCode warningCode = m_warningCodeMap.get(this.code);
        if (null == warningCode) {
            warningCode = WarningCode.GENERAL_WARNING;
        }
        return new Warning(warningCode, this.message, 0, 0, 0);
    }

    public void logMessageContent(IPGLogger logger) {
        String logMessage = "<=BE ErrorResponse (" + this.severity + ": " + this.message + "\n Position:" + this.position + ")";
        LogUtilities.logDebug(logMessage, (ILogger)logger);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\n" + this.getClass().getSimpleName());
        str.append(":");
        if (null != this.severity) {
            str.append("\nseverity - ");
            str.append(this.severity);
        }
        if (null != this.code) {
            str.append("\ncode - ");
            str.append(this.code);
        }
        if (null != this.message) {
            str.append("\nmessage - ");
            str.append(this.message);
        }
        if (null != this.detail) {
            str.append("\ndetail - ");
            str.append(this.detail);
        }
        if (null != this.hint) {
            str.append("\nhint - ");
            str.append(this.hint);
        }
        if (null != this.position) {
            str.append("\nposition - ");
            str.append(this.position);
        }
        if (null != this.internalPosition) {
            str.append("\ninternalPosition - ");
            str.append(this.internalPosition);
        }
        if (null != this.internalQuery) {
            str.append("\ninternalQuery - ");
            str.append(this.internalQuery);
        }
        if (null != this.where) {
            str.append("\nwhere - ");
            str.append(this.where);
        }
        if (null != this.schemaName) {
            str.append("\nschemaName - ");
            str.append(this.schemaName);
        }
        if (null != this.tableName) {
            str.append("\ntableName - ");
            str.append(this.tableName);
        }
        if (null != this.columnName) {
            str.append("\ncolumnName - ");
            str.append(this.columnName);
        }
        if (null != this.dataTypeName) {
            str.append("\ndataTypeName - ");
            str.append(this.dataTypeName);
        }
        if (null != this.constraintName) {
            str.append("\nconstraintName - ");
            str.append(this.constraintName);
        }
        if (null != this.file) {
            str.append("\nfile - ");
            str.append(this.file);
        }
        if (null != this.line) {
            str.append("\nline - ");
            str.append(this.line);
        }
        if (null != this.routine) {
            str.append("\nroutine - ");
            str.append(this.routine);
        }
        return str.toString();
    }

    private String buildErrorMessage() {
        if (null != this.message) {
            if (null != this.detail && !this.detail.isEmpty()) {
                return this.message + "\n" + "Details: " + "\n " + this.detail.trim();
            }
            return this.message;
        }
        return "";
    }

    static {
        HashMap<String, WarningCode> warningCodeMap = new HashMap<String, WarningCode>();
        warningCodeMap.put(SUCCESSFUL_COMPLETION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_01_WARNING, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_01_WARNING_DYNAMIC_RESULT_SETS_RETURNED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_01_WARNING_IMPLICIT_ZERO_BIT_PADDING, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_01_WARNING_NULL_VALUE_ELIMINATED_IN_SET_FUNCTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_01_WARNING_PRIVILEGE_NOT_GRANTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_01_WARNING_PRIVILEGE_NOT_REVOKED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_01_WARNING_STRING_DATA_RIGHT_TRUNCATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_01_WARNING_DEPRECATED_FEATURE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_02_NO_DATA, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_02_NO_DATA_NO_ADDITIONAL_DYNAMIC_RESULT_SETS_RETURNED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_03_SQL_STATEMENT_NOT_YET_COMPLETE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_08_CONNECTION_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_08_CONNECTION_EXCEPTION_CONNECTION_DOES_NOT_EXIST, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_08_CONNECTION_EXCEPTION_CONNECTION_FAILURE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_08_CONNECTION_EXCEPTION_SQLCLIENT_UNABLE_TO_ESTABLISH_SQLCONNECTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_08_CONNECTION_EXCEPTION_SQLSERVER_REJECTED_ESTABLISHMENT_OF_SQLCONNECTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_08_CONNECTION_EXCEPTION_TRANSACTION_RESOLUTION_UNKNOWN, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_08_CONNECTION_EXCEPTION_PROTOCOL_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_09_TRIGGERED_ACTION_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_0A_FEATURE_NOT_SUPPORTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_0B_INVALID_TRANSACTION_INITIATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_0F_LOCATOR_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_0F_LOCATOR_EXCEPTION_INVALID_LOCATOR_SPECIFICATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_0L_INVALID_GRANTOR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_0L_INVALID_GRANTOR_INVALID_GRANT_OPERATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_0P_INVALID_ROLE_SPECIFICATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_0Z_DIAGNOSTICS_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_0Z_STACKED_DIAGNOSTICS_ACCESSED_WITHOUT_ACTIVE_HANDLER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_20_CASE_NOT_FOUND, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_21_CARDINALITY_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_ARRAY_SUBSCRIPT_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_CHARACTER_NOT_IN_REPERTOIRE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_DATETIME_FIELD_OVERFLOW, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_DIVISION_BY_ZERO, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_ERROR_IN_ASSIGNMENT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_ESCAPE_CHARACTER_CONFLICT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INDICATOR_OVERFLOW, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INTERVAL_FIELD_OVERFLOW, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_LOGARITHM, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_NTILE_FUNCTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_NTH_VALUE_FUNCTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_POWER_FUNCTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_CHARACTER_VALUE_FOR_CAST, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_DATETIME_FORMAT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ESCAPE_CHARACTER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ESCAPE_OCTET, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ESCAPE_SEQUENCE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_NONSTANDARD_USE_OF_ESCAPE_CHARACTER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_INDICATOR_PARAMETER_VALUE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_PARAMETER_VALUE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_REGULAR_EXPRESSION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ROW_COUNT_IN_LIMIT_CLAUSE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ROW_COUNT_IN_RESULT_OFFSET_CLAUSE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_TIME_ZONE_DISPLACEMENT_VALUE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_USE_OF_ESCAPE_CHARACTER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_MOST_SPECIFIC_TYPE_MISMATCH, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_NULL_VALUE_NOT_ALLOWED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_NULL_VALUE_NO_INDICATOR_PARAMETER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_NUMERIC_VALUE_OUT_OF_RANGE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_STRING_DATA_LENGTH_MISMATCH, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_STRING_DATA_RIGHT_TRUNCATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_SUBSTRING_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_TRIM_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_UNTERMINATED_C_STRING, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_ZERO_LENGTH_CHARACTER_STRING, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_FLOATING_POINT_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_TEXT_REPRESENTATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_BINARY_REPRESENTATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_BAD_COPY_FILE_FORMAT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_UNTRANSLATABLE_CHARACTER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_NOT_AN_XML_DOCUMENT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_XML_DOCUMENT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_XML_CONTENT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_XML_COMMENT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_XML_PROCESSING_INSTRUCTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_RESTRICT_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_NOT_NULL_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_FOREIGN_KEY_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_UNIQUE_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_CHECK_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_EXCLUSION_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_24_INVALID_CURSOR_STATE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_ACTIVE_SQL_TRANSACTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_BRANCH_TRANSACTION_ALREADY_ACTIVE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_READ_ONLY_SQL_TRANSACTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_NO_ACTIVE_SQL_TRANSACTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_IN_FAILED_SQL_TRANSACTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_26_INVALID_SQL_STATEMENT_NAME, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_27_TRIGGERED_DATA_CHANGE_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_28_INVALID_AUTHORIZATION_SPECIFICATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_28_INVALID_AUTHORIZATION_SPECIFICATION_INVALID_PASSWORD, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_2B_DEPENDENT_PRIVILEGE_DESCRIPTORS_STILL_EXIST, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_2B_DEPENDENT_PRIVILEGE_DESCRIPTORS_STILL_EXIST_DEPENDENT_OBJECTS_STILL_EXIST, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_2D_INVALID_TRANSACTION_TERMINATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_2F_SQL_ROUTINE_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_2F_SQL_ROUTINE_EXCEPTION_FUNCTION_EXECUTED_NO_RETURN_STATEMENT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_2F_SQL_ROUTINE_EXCEPTION_MODIFYING_SQL_DATA_NOT_PERMITTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_2F_SQL_ROUTINE_EXCEPTION_PROHIBITED_SQL_STATEMENT_ATTEMPTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_2F_SQL_ROUTINE_EXCEPTION_READING_SQL_DATA_NOT_PERMITTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_34_INVALID_CURSOR_NAME, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_38_EXTERNAL_ROUTINE_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_CONTAINING_SQL_NOT_PERMITTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_MODIFYING_SQL_DATA_NOT_PERMITTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_PROHIBITED_SQL_STATEMENT_ATTEMPTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_READING_SQL_DATA_NOT_PERMITTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_INVALID_SQLSTATE_RETURNED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_NULL_VALUE_NOT_ALLOWED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_TRIGGER_PROTOCOL_VIOLATED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_SRF_PROTOCOL_VIOLATED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_3B_SAVEPOINT_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_3B_SAVEPOINT_EXCEPTION_INVALID_SAVEPOINT_SPECIFICATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_3D_INVALID_CATALOG_NAME, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_3F_INVALID_SCHEMA_NAME, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_40_TRANSACTION_ROLLBACK, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_40_TRANSACTION_ROLLBACK_TRANSACTION_INTEGRITY_CONSTRAINT_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_40_TRANSACTION_ROLLBACK_SERIALIZATION_FAILURE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_40_TRANSACTION_ROLLBACK_STATEMENT_COMPLETION_UNKNOWN, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_40_TRANSACTION_ROLLBACK_DEADLOCK_DETECTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_SYNTAX_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INSUFFICIENT_PRIVILEGE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_CANNOT_COERCE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_GROUPING_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_WINDOWING_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_RECURSION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_FOREIGN_KEY, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_NAME, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_NAME_TOO_LONG, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_RESERVED_NAME, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DATATYPE_MISMATCH, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INDETERMINATE_DATATYPE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_COLLATION_MISMATCH, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INDETERMINATE_COLLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_WRONG_OBJECT_TYPE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_COLUMN, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_FUNCTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_TABLE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_PARAMETER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_OBJECT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_COLUMN, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_CURSOR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_DATABASE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_FUNCTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_PREPARED_STATEMENT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_SCHEMA, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_TABLE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_ALIAS, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_OBJECT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_COLUMN, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_FUNCTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_PARAMETER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_ALIAS, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_COLUMN_REFERENCE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_COLUMN_DEFINITION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_CURSOR_DEFINITION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_DATABASE_DEFINITION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_FUNCTION_DEFINITION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_PREPARED_STATEMENT_DEFINITION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_SCHEMA_DEFINITION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_TABLE_DEFINITION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_OBJECT_DEFINITION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_44_WITH_CHECK_OPTION_VIOLATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_53_INSUFFICIENT_RESOURCES, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_53_INSUFFICIENT_RESOURCES_DISK_FULL, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_53_INSUFFICIENT_RESOURCES_OUT_OF_MEMORY, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_53_INSUFFICIENT_RESOURCES_TOO_MANY_CONNECTIONS, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_53_INSUFFICIENT_RESOURCES_CONFIGURATION_LIMIT_EXCEEDED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_54_PROGRAM_LIMIT_EXCEEDED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_54_PROGRAM_LIMIT_EXCEEDED_STATEMENT_TOO_COMPLEX, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_54_PROGRAM_LIMIT_EXCEEDED_TOO_MANY_COLUMNS, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_54_PROGRAM_LIMIT_EXCEEDED_TOO_MANY_ARGUMENTS, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE_OBJECT_IN_USE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE_CANT_CHANGE_RUNTIME_PARAM, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE_LOCK_NOT_AVAILABLE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_57_OPERATOR_INTERVENTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_57_OPERATOR_INTERVENTION_QUERY_CANCELED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_57_OPERATOR_INTERVENTION_ADMIN_SHUTDOWN, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_57_OPERATOR_INTERVENTION_CRASH_SHUTDOWN, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_57_OPERATOR_INTERVENTION_CANNOT_CONNECT_NOW, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_57_OPERATOR_INTERVENTION_DATABASE_DROPPED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_58_SYSTEM_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_58_SYSTEM_ERROR_IO_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_58_SYSTEM_ERROR_UNDEFINED_FILE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_58_SYSTEM_ERROR_DUPLICATE_FILE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_F0_CONFIG_FILE_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_F0_CONFIG_FILE_ERROR_LOCK_FILE_EXISTS, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_COLUMN_NAME_NOT_FOUND, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_DYNAMIC_PARAMETER_VALUE_NEEDED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_FUNCTION_SEQUENCE_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INCONSISTENT_DESCRIPTOR_INFORMATION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_ATTRIBUTE_VALUE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_COLUMN_NAME, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_COLUMN_NUMBER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_DATA_TYPE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_DATA_TYPE_DESCRIPTORS, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_DESCRIPTOR_FIELD_IDENTIFIER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_HANDLE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_OPTION_INDEX, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_OPTION_NAME, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_STRING_LENGTH_OR_BUFFER_LENGTH, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_STRING_FORMAT, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_USE_OF_NULL_POINTER, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_TOO_MANY_HANDLES, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_OUT_OF_MEMORY, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_NO_SCHEMAS, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_OPTION_NAME_NOT_FOUND, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_REPLY_HANDLE, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_SCHEMA_NOT_FOUND, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_TABLE_NOT_FOUND, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_UNABLE_TO_CREATE_EXECUTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_UNABLE_TO_CREATE_REPLY, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_HV_FDW_ERROR_FDW_UNABLE_TO_ESTABLISH_CONNECTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_P0_PLPGSQL_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_P0_PLPGSQL_ERROR_RAISE_EXCEPTION, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_P0_PLPGSQL_ERROR_NO_DATA_FOUND, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_P0_PLPGSQL_ERROR_TOO_MANY_ROWS, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_XX_INTERNAL_ERROR, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_XX_INTERNAL_ERROR_DATA_CORRUPTED, WarningCode.GENERAL_WARNING);
        warningCodeMap.put(CLASS_XX_INTERNAL_ERROR_INDEX_CORRUPTED, WarningCode.GENERAL_WARNING);
        m_warningCodeMap = Collections.unmodifiableMap(warningCodeMap);
        HashMap<String, ExceptionType> exceptionTypeMap = new HashMap<String, ExceptionType>();
        exceptionTypeMap.put(SUCCESSFUL_COMPLETION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_01_WARNING, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_01_WARNING_DYNAMIC_RESULT_SETS_RETURNED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_01_WARNING_IMPLICIT_ZERO_BIT_PADDING, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_01_WARNING_NULL_VALUE_ELIMINATED_IN_SET_FUNCTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_01_WARNING_PRIVILEGE_NOT_GRANTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_01_WARNING_PRIVILEGE_NOT_REVOKED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_01_WARNING_STRING_DATA_RIGHT_TRUNCATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_01_WARNING_DEPRECATED_FEATURE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_02_NO_DATA, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_02_NO_DATA_NO_ADDITIONAL_DYNAMIC_RESULT_SETS_RETURNED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_03_SQL_STATEMENT_NOT_YET_COMPLETE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_08_CONNECTION_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_08_CONNECTION_EXCEPTION_CONNECTION_DOES_NOT_EXIST, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_08_CONNECTION_EXCEPTION_CONNECTION_FAILURE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_08_CONNECTION_EXCEPTION_SQLCLIENT_UNABLE_TO_ESTABLISH_SQLCONNECTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_08_CONNECTION_EXCEPTION_SQLSERVER_REJECTED_ESTABLISHMENT_OF_SQLCONNECTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_08_CONNECTION_EXCEPTION_TRANSACTION_RESOLUTION_UNKNOWN, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_08_CONNECTION_EXCEPTION_PROTOCOL_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_09_TRIGGERED_ACTION_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_0A_FEATURE_NOT_SUPPORTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_0B_INVALID_TRANSACTION_INITIATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_0F_LOCATOR_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_0F_LOCATOR_EXCEPTION_INVALID_LOCATOR_SPECIFICATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_0L_INVALID_GRANTOR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_0L_INVALID_GRANTOR_INVALID_GRANT_OPERATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_0P_INVALID_ROLE_SPECIFICATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_0Z_DIAGNOSTICS_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_0Z_STACKED_DIAGNOSTICS_ACCESSED_WITHOUT_ACTIVE_HANDLER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_20_CASE_NOT_FOUND, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_21_CARDINALITY_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_ARRAY_SUBSCRIPT_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_CHARACTER_NOT_IN_REPERTOIRE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_DATETIME_FIELD_OVERFLOW, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_DIVISION_BY_ZERO, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_ERROR_IN_ASSIGNMENT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_ESCAPE_CHARACTER_CONFLICT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INDICATOR_OVERFLOW, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INTERVAL_FIELD_OVERFLOW, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_LOGARITHM, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_NTILE_FUNCTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_NTH_VALUE_FUNCTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_POWER_FUNCTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_CHARACTER_VALUE_FOR_CAST, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_DATETIME_FORMAT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ESCAPE_CHARACTER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ESCAPE_OCTET, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ESCAPE_SEQUENCE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_NONSTANDARD_USE_OF_ESCAPE_CHARACTER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_INDICATOR_PARAMETER_VALUE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_PARAMETER_VALUE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_REGULAR_EXPRESSION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ROW_COUNT_IN_LIMIT_CLAUSE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_ROW_COUNT_IN_RESULT_OFFSET_CLAUSE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_TIME_ZONE_DISPLACEMENT_VALUE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_USE_OF_ESCAPE_CHARACTER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_MOST_SPECIFIC_TYPE_MISMATCH, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_NULL_VALUE_NOT_ALLOWED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_NULL_VALUE_NO_INDICATOR_PARAMETER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_NUMERIC_VALUE_OUT_OF_RANGE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_STRING_DATA_LENGTH_MISMATCH, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_STRING_DATA_RIGHT_TRUNCATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_SUBSTRING_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_TRIM_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_UNTERMINATED_C_STRING, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_ZERO_LENGTH_CHARACTER_STRING, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_FLOATING_POINT_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_TEXT_REPRESENTATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_BINARY_REPRESENTATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_BAD_COPY_FILE_FORMAT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_UNTRANSLATABLE_CHARACTER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_NOT_AN_XML_DOCUMENT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_XML_DOCUMENT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_XML_CONTENT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_XML_COMMENT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_22_DATA_EXCEPTION_INVALID_XML_PROCESSING_INSTRUCTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_RESTRICT_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_NOT_NULL_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_FOREIGN_KEY_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_UNIQUE_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_CHECK_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_23_INTEGRITY_CONSTRAINT_VIOLATION_EXCLUSION_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_24_INVALID_CURSOR_STATE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_ACTIVE_SQL_TRANSACTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_BRANCH_TRANSACTION_ALREADY_ACTIVE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_READ_ONLY_SQL_TRANSACTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_NO_ACTIVE_SQL_TRANSACTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_25_INVALID_TRANSACTION_STATE_IN_FAILED_SQL_TRANSACTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_26_INVALID_SQL_STATEMENT_NAME, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_27_TRIGGERED_DATA_CHANGE_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_28_INVALID_AUTHORIZATION_SPECIFICATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_28_INVALID_AUTHORIZATION_SPECIFICATION_INVALID_PASSWORD, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_2B_DEPENDENT_PRIVILEGE_DESCRIPTORS_STILL_EXIST, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_2B_DEPENDENT_PRIVILEGE_DESCRIPTORS_STILL_EXIST_DEPENDENT_OBJECTS_STILL_EXIST, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_2D_INVALID_TRANSACTION_TERMINATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_2F_SQL_ROUTINE_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_2F_SQL_ROUTINE_EXCEPTION_FUNCTION_EXECUTED_NO_RETURN_STATEMENT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_2F_SQL_ROUTINE_EXCEPTION_MODIFYING_SQL_DATA_NOT_PERMITTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_2F_SQL_ROUTINE_EXCEPTION_PROHIBITED_SQL_STATEMENT_ATTEMPTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_2F_SQL_ROUTINE_EXCEPTION_READING_SQL_DATA_NOT_PERMITTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_34_INVALID_CURSOR_NAME, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_38_EXTERNAL_ROUTINE_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_CONTAINING_SQL_NOT_PERMITTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_MODIFYING_SQL_DATA_NOT_PERMITTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_PROHIBITED_SQL_STATEMENT_ATTEMPTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_38_EXTERNAL_ROUTINE_EXCEPTION_READING_SQL_DATA_NOT_PERMITTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_INVALID_SQLSTATE_RETURNED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_NULL_VALUE_NOT_ALLOWED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_TRIGGER_PROTOCOL_VIOLATED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION_SRF_PROTOCOL_VIOLATED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_3B_SAVEPOINT_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_3B_SAVEPOINT_EXCEPTION_INVALID_SAVEPOINT_SPECIFICATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_3D_INVALID_CATALOG_NAME, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_3F_INVALID_SCHEMA_NAME, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_40_TRANSACTION_ROLLBACK, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_40_TRANSACTION_ROLLBACK_TRANSACTION_INTEGRITY_CONSTRAINT_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_40_TRANSACTION_ROLLBACK_SERIALIZATION_FAILURE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_40_TRANSACTION_ROLLBACK_STATEMENT_COMPLETION_UNKNOWN, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_40_TRANSACTION_ROLLBACK_DEADLOCK_DETECTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_SYNTAX_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INSUFFICIENT_PRIVILEGE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_CANNOT_COERCE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_GROUPING_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_WINDOWING_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_RECURSION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_FOREIGN_KEY, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_NAME, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_NAME_TOO_LONG, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_RESERVED_NAME, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DATATYPE_MISMATCH, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INDETERMINATE_DATATYPE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_COLLATION_MISMATCH, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INDETERMINATE_COLLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_WRONG_OBJECT_TYPE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_COLUMN, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_FUNCTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_TABLE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_PARAMETER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_UNDEFINED_OBJECT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_COLUMN, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_CURSOR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_DATABASE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_FUNCTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_PREPARED_STATEMENT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_SCHEMA, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_TABLE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_ALIAS, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_DUPLICATE_OBJECT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_COLUMN, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_FUNCTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_PARAMETER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_AMBIGUOUS_ALIAS, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_COLUMN_REFERENCE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_COLUMN_DEFINITION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_CURSOR_DEFINITION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_DATABASE_DEFINITION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_FUNCTION_DEFINITION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_PREPARED_STATEMENT_DEFINITION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_SCHEMA_DEFINITION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_TABLE_DEFINITION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION_INVALID_OBJECT_DEFINITION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_44_WITH_CHECK_OPTION_VIOLATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_53_INSUFFICIENT_RESOURCES, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_53_INSUFFICIENT_RESOURCES_DISK_FULL, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_53_INSUFFICIENT_RESOURCES_OUT_OF_MEMORY, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_53_INSUFFICIENT_RESOURCES_TOO_MANY_CONNECTIONS, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_53_INSUFFICIENT_RESOURCES_CONFIGURATION_LIMIT_EXCEEDED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_54_PROGRAM_LIMIT_EXCEEDED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_54_PROGRAM_LIMIT_EXCEEDED_STATEMENT_TOO_COMPLEX, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_54_PROGRAM_LIMIT_EXCEEDED_TOO_MANY_COLUMNS, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_54_PROGRAM_LIMIT_EXCEEDED_TOO_MANY_ARGUMENTS, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE_OBJECT_IN_USE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE_CANT_CHANGE_RUNTIME_PARAM, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_55_OBJECT_NOT_IN_PREREQUISITE_STATE_LOCK_NOT_AVAILABLE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_57_OPERATOR_INTERVENTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_57_OPERATOR_INTERVENTION_QUERY_CANCELED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_57_OPERATOR_INTERVENTION_ADMIN_SHUTDOWN, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_57_OPERATOR_INTERVENTION_CRASH_SHUTDOWN, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_57_OPERATOR_INTERVENTION_CANNOT_CONNECT_NOW, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_57_OPERATOR_INTERVENTION_DATABASE_DROPPED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_58_SYSTEM_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_58_SYSTEM_ERROR_IO_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_58_SYSTEM_ERROR_UNDEFINED_FILE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_58_SYSTEM_ERROR_DUPLICATE_FILE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_F0_CONFIG_FILE_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_F0_CONFIG_FILE_ERROR_LOCK_FILE_EXISTS, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_COLUMN_NAME_NOT_FOUND, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_DYNAMIC_PARAMETER_VALUE_NEEDED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_FUNCTION_SEQUENCE_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INCONSISTENT_DESCRIPTOR_INFORMATION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_ATTRIBUTE_VALUE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_COLUMN_NAME, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_COLUMN_NUMBER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_DATA_TYPE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_DATA_TYPE_DESCRIPTORS, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_DESCRIPTOR_FIELD_IDENTIFIER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_HANDLE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_OPTION_INDEX, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_OPTION_NAME, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_STRING_LENGTH_OR_BUFFER_LENGTH, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_STRING_FORMAT, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_INVALID_USE_OF_NULL_POINTER, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_TOO_MANY_HANDLES, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_OUT_OF_MEMORY, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_NO_SCHEMAS, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_OPTION_NAME_NOT_FOUND, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_REPLY_HANDLE, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_SCHEMA_NOT_FOUND, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_TABLE_NOT_FOUND, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_UNABLE_TO_CREATE_EXECUTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_UNABLE_TO_CREATE_REPLY, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_HV_FDW_ERROR_FDW_UNABLE_TO_ESTABLISH_CONNECTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_P0_PLPGSQL_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_P0_PLPGSQL_ERROR_RAISE_EXCEPTION, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_P0_PLPGSQL_ERROR_NO_DATA_FOUND, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_P0_PLPGSQL_ERROR_TOO_MANY_ROWS, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_XX_INTERNAL_ERROR, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_XX_INTERNAL_ERROR_DATA_CORRUPTED, ExceptionType.DEFAULT);
        exceptionTypeMap.put(CLASS_XX_INTERNAL_ERROR_INDEX_CORRUPTED, ExceptionType.DEFAULT);
        m_exceptionTypeMap = Collections.unmodifiableMap(exceptionTypeMap);
        SEVERITY_TRANSLATION_BUNDLE = ResourceBundle.getBundle(ErrorResponse.class.getName(), new Locale("en", "US"));
    }

    public static enum Severity {
        ERROR,
        FATAL,
        PANIC,
        WARNING,
        NOTICE,
        DEBUG,
        INFO,
        LOG;

    }
}

