/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class KeyData
extends AbstractInboundMessage
implements PGConstants {
    private final byte[] m_processID = new byte[4];
    private final byte[] m_secretKey = new byte[4];

    public KeyData(ByteBuffer buffer, IPGLogger logger) {
        buffer.get(this.m_processID);
        buffer.get(this.m_secretKey);
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public byte[] getProcessID() {
        return this.m_processID;
    }

    public byte[] getSecretKey() {
        return this.m_secretKey;
    }

    public void logMessageContent(IPGLogger logger) {
        String processId = new String(PGDataTypeUtilities.toHexString(this.getProcessID()));
        String secretKey = new String(PGDataTypeUtilities.toHexString(this.getSecretKey()));
        StringBuilder str = new StringBuilder();
        str.append("<=BE KeyData(pid=");
        str.append(processId);
        str.append(",ckey=");
        str.append(secretKey);
        str.append(")");
        logger.logDebugExternal(str.toString());
    }

    public String toString() {
        String processId = new String(PGDataTypeUtilities.toHexString(this.getProcessID()));
        String secretKey = new String(PGDataTypeUtilities.toHexString(this.getSecretKey()));
        StringBuilder str = new StringBuilder();
        str.append("\nKeyData: getProcessID - ");
        str.append(processId);
        str.append(", getSecretKey - ");
        str.append(secretKey);
        return str.toString();
    }
}

