/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.interfaces.Notification;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import java.nio.ByteBuffer;

public class NotificationResponse
extends AbstractInboundMessage
implements Notification,
PGConstants {
    private static final String WARNING_MESSAGE_PART1 = "Notify,";
    private static final String WARNING_MESSAGE_PART2 = "name=";
    private static final String WARNING_MESSAGE_PART3 = ",payload=";
    private static final String WARNING_MESSAGE_PART4 = ",PID=";
    private int m_processID = -1;
    private String m_name = null;
    private String m_payload = null;

    public NotificationResponse(ByteBuffer buffer, IPGLogger logger) {
        byte[] processID = new byte[4];
        buffer.get(processID);
        this.m_processID = PGDataTypeUtilities.toInt(processID);
        this.m_name = this.getNullTerminatedFieldAsUTF8String(buffer);
        this.m_payload = this.getNullTerminatedFieldAsUTF8String(buffer);
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public NotificationResponse(Warning warning) {
        String warningMessage = warning.getMessage();
        warningMessage = warningMessage.replace(WARNING_MESSAGE_PART1, "");
        int startName = warningMessage.indexOf("=");
        int endName = warningMessage.indexOf(",");
        int startPayload = warningMessage.indexOf("=", endName);
        int endPayload = warningMessage.indexOf(",", endName + 1);
        int startPID = warningMessage.indexOf("=", endPayload);
        if (-1 != startName && -1 != endName) {
            this.m_name = warningMessage.substring(startName + 1, endName);
        }
        if (-1 != startPayload && -1 != endPayload) {
            this.m_payload = warningMessage.substring(startPayload + 1, endPayload);
        }
        if (-1 != startPID) {
            this.m_processID = Integer.parseInt(warningMessage.substring(startPID + 1, warningMessage.length()));
        }
    }

    public Warning toWarning() {
        StringBuffer sb = new StringBuffer();
        sb.append(WARNING_MESSAGE_PART1);
        sb.append(WARNING_MESSAGE_PART2);
        sb.append(this.m_name);
        sb.append(WARNING_MESSAGE_PART3);
        sb.append(this.m_payload);
        sb.append(WARNING_MESSAGE_PART4);
        sb.append(this.m_processID);
        return new Warning(WarningCode.GENERAL_WARNING, sb.toString());
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getPayload() {
        return this.m_payload;
    }

    @Override
    public int getProcessId() {
        return this.m_processID;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "<=BE NotificationResponse(name=" + this.m_name + ", payload= " + this.m_payload + ")";
        logger.logDebugExternal(message);
    }

    public String toString() {
        return "\nNotificationResponse: name - `" + this.m_name + "`, payload - `" + this.m_payload + "`";
    }
}

