/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc41;

import com.amazon.jdbc.common.JDBCObjectFactory;
import com.amazon.jdbc.jdbc41.JDBC41AbstractDataSource;
import com.amazon.redshift.PGInfo;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.jdbc41.PGJDBC41ObjectFactory;
import java.util.Properties;

public abstract class PGJDBC41DataSource
extends JDBC41AbstractDataSource {
    private String m_language = null;
    protected boolean m_isUsingOpenSourceSubProtocol = false;

    @Override
    protected boolean acceptsSubProtocol(String givenSubProtocol) {
        boolean result = false;
        String[] subProtocol = this.getSubProtocols();
        if (null == subProtocol) {
            return false;
        }
        this.m_isUsingOpenSourceSubProtocol = givenSubProtocol.equals("postgresql");
        for (int i = 0; !result && i < subProtocol.length; ++i) {
            result = givenSubProtocol.equals(subProtocol[i]);
        }
        return result;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    @Override
    protected JDBCObjectFactory createJDBCObjectFactory() {
        return new PGJDBC41ObjectFactory();
    }

    @Override
    protected Properties getProperties() {
        Properties props = super.getProperties();
        if (null != this.m_language) {
            props.put("Language", this.m_language);
        }
        return props;
    }

    @Override
    public String getSubProtocol() {
        return null;
    }

    @Override
    protected boolean parseSubName(String subname, Properties properties) {
        return PGCoreUtils.parseSubName(subname, properties, this.m_isUsingOpenSourceSubProtocol);
    }

    private String[] getSubProtocols() {
        return PGInfo.PG_SUBPROTOCAL_NAME;
    }
}

