/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc41;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.jdbc.common.SCallableStatement;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SDatabaseMetaData;
import com.amazon.jdbc.common.SPreparedStatement;
import com.amazon.jdbc.common.SStatement;
import com.amazon.jdbc.jdbc41.JDBC41ObjectFactory;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.core.jdbc41.PGJDBC41CallableStatement;
import com.amazon.redshift.core.jdbc41.PGJDBC41DatabaseMetaData;
import com.amazon.redshift.core.jdbc41.PGJDBC41PreparedStatement;
import com.amazon.redshift.core.jdbc41.PGJDBC41Statement;
import com.amazon.redshift.jdbc41.S41NotifiedConnection;
import com.amazon.support.ILogger;
import java.sql.SQLException;

public class PGJDBC41ObjectFactory
extends JDBC41ObjectFactory {
    protected PGJDBC41ObjectFactory() {
    }

    @Override
    protected SCallableStatement createCallableStatement(String sql, IStatement dsiStatement, SConnection parentConnection, int concurrency) throws SQLException {
        PGJDBCStatement callableStatement = (PGJDBCStatement)dsiStatement;
        callableStatement.setIsCallableStatement(true);
        return new PGJDBC41CallableStatement(sql, callableStatement, parentConnection, concurrency);
    }

    @Override
    protected SConnection createConnection(IConnection dsiConnection, String url) throws SQLException {
        return new S41NotifiedConnection(dsiConnection, url);
    }

    @Override
    protected SDatabaseMetaData createDatabaseMetaData(SConnection conn, ILogger logger) throws SQLException {
        IConnection DSIcon = null;
        if (conn != null) {
            DSIcon = conn.getDSIConnection();
        }
        return new PGJDBC41DatabaseMetaData(DSIcon, conn, logger);
    }

    @Override
    protected SPreparedStatement createPreparedStatement(String sql, IStatement dsiStatement, SConnection parentConnection, int concurrency) throws SQLException {
        return new PGJDBC41PreparedStatement(sql, dsiStatement, parentConnection, concurrency);
    }

    @Override
    protected SStatement createStatement(IStatement dsiStatement, SConnection parentConnection, int concurrency) throws SQLException {
        return new PGJDBC41Statement(dsiStatement, parentConnection, concurrency);
    }
}

