/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.impl.DSIErrorResult;
import com.amazon.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResults;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

public class PGBatchExecutionResults
extends ExecutionResults {
    private final ILogger m_log;

    public PGBatchExecutionResults(List<PGMessagingContext> contexts, ILogger logger, int socketTimeoutMS) throws ErrorException {
        this.m_log = logger;
        for (PGMessagingContext current : contexts) {
            try {
                int totalExecutions = current.m_batchCount;
                int totalRowCount = 0;
                for (int batchIndex = 0; batchIndex < totalExecutions; ++batchIndex) {
                    boolean resultAdded = false;
                    while (!resultAdded) {
                        try {
                            IInboundMessage peeked;
                            if (current.m_totalMessageCount > current.m_currentMessageCount && (peeked = current.peekNextMessage(socketTimeoutMS)) instanceof ErrorResponse) {
                                current.getErrorResponse();
                            }
                            if (current.m_isPreparedStatement && null == current.m_readyForQueryFromPipelineForPrepare) {
                                current.getReadyForQuery();
                            }
                            CommandComplete commandComplete = null;
                            while (current.m_batchCommandComplete.size() < batchIndex + 1 || null == (commandComplete = current.m_batchCommandComplete.get(batchIndex))) {
                                current.doMoveToNextClass(CommandComplete.class);
                            }
                            totalRowCount = (int)((long)totalRowCount + commandComplete.getNumRows());
                            resultAdded = true;
                        }
                        catch (ErrorException e) {
                            DSIErrorResult error = new DSIErrorResult(e);
                            this.addExecutionResult(new ExecutionResult(error, false));
                            resultAdded = true;
                            throw e;
                        }
                    }
                }
                this.addExecutionResult(new ExecutionResult(new DSISimpleRowCountResult(totalRowCount)));
            }
            catch (Exception ex) {
                ErrorException err = current.receivedFatalExeption();
                if (null != err) {
                    throw err;
                }
                if (ex instanceof ErrorException) {
                    throw (ErrorException)ex;
                }
                err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
                err.initCause(ex);
                throw err;
            }
        }
    }
}

