/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.redshift.api.PGArrayColumnMetaData;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.api.PGTimestamp;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.core.PGArray;
import com.amazon.redshift.core.PGArrayParser;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.metadata.ColumnsIsNullResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.GeneralException;
import com.amazon.utilities.TypeNames;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;

public class PGResultSet
implements IResultSet,
PGConstants,
SocketCloseListener {
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    private ArrayList<ColumnMetadata> m_columnMetadata;
    private PGMessagingContext m_currentMessagingContext = null;
    protected ILogger m_log;
    private int m_fetchSize;
    private long m_currentRow = 0L;
    private boolean m_hasStartedFetch = false;
    private IWarningListener m_warningListener = null;
    private ErrorException m_fatalException = null;

    public PGResultSet(PGMessagingContext contexts, ILogger logger) {
        this.m_currentMessagingContext = contexts;
        this.m_log = logger;
        this.m_currentMessagingContext.addSocketCloseListener(this);
    }

    @Override
    public boolean getData(int column, long offset, long maxSize, DataWrapper retrievedData) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            if (column < this.m_currentMessagingContext.m_currentDataRow.getNumberOfColumns()) {
                ColumnMetadata colMeta = this.getSelectColumns().get(column);
                byte[] data = this.m_currentMessagingContext.m_currentDataRow.getData();
                int columnBeginIndex = this.m_currentMessagingContext.m_currentDataRow.getColumnBeginIndex(column);
                int columnEndIndex = this.m_currentMessagingContext.m_currentDataRow.getColumnEndIndex(column);
                int length = columnEndIndex - columnBeginIndex + 1;
                if (-1 == columnEndIndex) {
                    retrievedData.setNull(colMeta.getTypeMetadata().getType());
                    return false;
                }
                switch (colMeta.getTypeMetadata().getType()) {
                    case 2003: {
                        if (colMeta instanceof PGArrayColumnMetaData) {
                            Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                            if (null != converted && converted instanceof PGArray) {
                                retrievedData.setArray((PGArray)converted);
                            } else {
                                PGArrayColumnMetaData arrayColMeta = (PGArrayColumnMetaData)colMeta;
                                int baseType = arrayColMeta.getBaseType();
                                IColumn baseColMeta = arrayColMeta.getBaseColumnMetadata();
                                Object array = PGArrayParser.parseArray(data, baseType, columnBeginIndex, length);
                                PGArray pgArray = new PGArray(array, colMeta, baseColMeta);
                                this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, pgArray);
                                retrievedData.setArray(pgArray);
                            }
                            return false;
                        }
                        throw new GeneralException(1, JDBCMessageKey.INVALID_COLUMN_TYPE.name(), new String[]{String.valueOf(column), TypeNames.getTypeName(2003)});
                    }
                    case 1: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof String) {
                            retrievedData.setChar(PGDataTypeUtilities.convertStringToUTF8((String)converted));
                        } else {
                            String value = PGDataTypeUtilities.toUTF8String(data, columnBeginIndex, length);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, value);
                            retrievedData.setChar(value);
                        }
                        return false;
                    }
                    case 12: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof String) {
                            retrievedData.setVarChar(PGDataTypeUtilities.convertStringToUTF8((String)converted));
                        } else {
                            String value = PGDataTypeUtilities.toUTF8String(data, columnBeginIndex, length);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, value);
                            retrievedData.setVarChar(value);
                        }
                        return false;
                    }
                    case -1: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof String) {
                            retrievedData.setLongVarChar(PGDataTypeUtilities.convertStringToUTF8((String)converted));
                        } else {
                            String value = PGDataTypeUtilities.toUTF8String(data, columnBeginIndex, length);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, value);
                            retrievedData.setLongVarChar(value);
                        }
                        return false;
                    }
                    case -4: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof byte[]) {
                            retrievedData.setLongVarBinary((byte[])converted);
                        } else {
                            byte[] binary = PGDataTypeUtilities.transformByteFormat(data, columnBeginIndex, length);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, binary);
                            retrievedData.setLongVarBinary(binary);
                        }
                        return false;
                    }
                    case -7: 
                    case 16: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof String) {
                            retrievedData.setVarChar((String)converted);
                        } else {
                            String booleanValue = null;
                            booleanValue = PGDataTypeUtilities.toBit(data, columnBeginIndex) != false ? TRUE : FALSE;
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, booleanValue);
                            retrievedData.setVarChar(booleanValue);
                        }
                        return false;
                    }
                    case 5: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof Integer) {
                            retrievedData.setSmallInt((Integer)converted);
                        } else {
                            Integer sh = new Integer(PGDataTypeUtilities.toShort(data, columnBeginIndex, length));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, sh);
                            retrievedData.setSmallInt(sh);
                        }
                        return false;
                    }
                    case 4: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof Long) {
                            retrievedData.setInteger((Long)converted);
                        } else {
                            Long integer = new Long(PGDataTypeUtilities.toInteger(data, columnBeginIndex, length));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, integer);
                            retrievedData.setInteger(integer);
                        }
                        return false;
                    }
                    case -5: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof Long) {
                            retrievedData.setBigInt((Long)converted);
                        } else {
                            Long bigint = new Long(PGDataTypeUtilities.toLong(data, columnBeginIndex, length));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, bigint);
                            retrievedData.setBigInt(bigint);
                        }
                        return false;
                    }
                    case 7: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof Float) {
                            retrievedData.setReal((Float)converted);
                        } else {
                            Float real = new Float(PGDataTypeUtilities.toFloat(data, columnBeginIndex, length));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, real);
                            retrievedData.setReal(real);
                        }
                        return false;
                    }
                    case 8: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof Double) {
                            retrievedData.setDouble((Double)converted);
                        } else {
                            Double doub = new Double(PGDataTypeUtilities.toDouble(data, columnBeginIndex, length));
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, doub);
                            retrievedData.setDouble(doub);
                        }
                        return false;
                    }
                    case 91: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof Date) {
                            retrievedData.setDate((Date)converted);
                        } else {
                            int[] dateValueList = PGDataTypeUtilities.toDate(data, columnBeginIndex, length);
                            Date date = PGDataTypeUtilities.toSqlDate(dateValueList);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, date);
                            retrievedData.setDate(date);
                        }
                        return false;
                    }
                    case 92: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof int[]) {
                            int[] timeValueList = (int[])converted;
                            retrievedData.setTime(timeValueList[0], timeValueList[1], timeValueList[2], timeValueList[3]);
                        } else {
                            int[] timeValueList = PGDataTypeUtilities.toTime(data, columnBeginIndex, length);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, timeValueList);
                            retrievedData.setTime(timeValueList[0], timeValueList[1], timeValueList[2], timeValueList[3]);
                        }
                        return false;
                    }
                    case 93: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof PGTimestamp) {
                            retrievedData.setTimestamp((PGTimestamp)converted);
                        } else if (null != converted && converted instanceof int[]) {
                            int[] timestampValueList = (int[])converted;
                            Timestamp timestamp = PGDataTypeUtilities.toSqlTimestamp(timestampValueList);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, timestamp);
                            retrievedData.setTimestamp(timestamp);
                        } else {
                            String timestampString = PGDataTypeUtilities.toUTF8String(data, columnBeginIndex, length);
                            if ((timestampString = timestampString.toLowerCase()).contains("infinity")) {
                                if (timestampString.startsWith("-")) {
                                    retrievedData.setTimestamp(new PGTimestamp(Long.MIN_VALUE));
                                } else {
                                    retrievedData.setTimestamp(new PGTimestamp(Long.MAX_VALUE));
                                }
                            } else {
                                int[] timestampValueList = PGDataTypeUtilities.toTimestamp(data, columnBeginIndex, length);
                                Timestamp timestamp = PGDataTypeUtilities.toSqlTimestamp(timestampValueList);
                                retrievedData.setTimestamp(timestamp);
                            }
                        }
                        return false;
                    }
                    case 2: 
                    case 3: {
                        Object converted = this.m_currentMessagingContext.m_currentDataRow.getConvertedObject(column);
                        if (null != converted && converted instanceof BigDecimal) {
                            retrievedData.setNumeric((BigDecimal)converted);
                        } else {
                            BigDecimal bigDecimal = PGDataTypeUtilities.toBigDecimal(data, columnBeginIndex, length);
                            this.m_currentMessagingContext.m_currentDataRow.setConvertedObject(column, bigDecimal);
                            retrievedData.setNumeric(bigDecimal);
                        }
                        return false;
                    }
                }
            }
        }
        catch (Exception ex) {
            LogUtilities.logError(ex, this.m_log);
            throw this.buildError(ex);
        }
        return false;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            return this.m_currentMessagingContext.m_dataRowCount;
        }
        catch (Exception ex) {
            LogUtilities.logError(ex, this.m_log);
            throw this.buildError(ex);
        }
    }

    public ArrayList<ColumnMetadata> getSelectColumns() throws ErrorException {
        return this.getSelectColumns(true);
    }

    public ArrayList<ColumnMetadata> getSelectColumns(boolean resolveNullable) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            if (null == this.m_columnMetadata) {
                this.m_columnMetadata = new ArrayList();
                RowDescription rowDesc = this.m_currentMessagingContext.getRowDescription();
                if (null != rowDesc) {
                    ColumnsIsNullResultSet columnsIsNullResultSet = this.m_currentMessagingContext.m_columnsIsNullResultSet;
                    for (int i = 0; i < rowDesc.getFieldDescriptions().length; ++i) {
                        Boolean isNullable = null;
                        if (null != columnsIsNullResultSet) {
                            isNullable = columnsIsNullResultSet.isNullable(rowDesc.getFieldDescriptions()[i].getTableObjectIDString(), rowDesc.getFieldDescriptions()[i].getColumnAttributeNumberString());
                        }
                        this.m_columnMetadata.add(PGDataTypeUtilities.createColumn(null, null, null, PGDataTypeUtilities.toUTF8String(rowDesc.getFieldDescriptions()[i].getFieldName()), rowDesc.getFieldDescriptions()[i], isNullable));
                    }
                }
            }
        }
        catch (Exception ex) {
            LogUtilities.logError(ex, this.m_log);
            throw this.buildError(ex);
        }
        return this.m_columnMetadata;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (this.m_currentMessagingContext.hasOpenOperation()) {
            return true;
        }
        return this.getRowCount() > this.getCurrentRow();
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return !this.m_currentMessagingContext.hasOpenOperation();
    }

    @Override
    public void appendRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_currentMessagingContext.closeOperation();
        this.m_currentMessagingContext.removeSocketCloseListener(this);
    }

    @Override
    public void closeCursor() throws ErrorException {
        this.m_hasStartedFetch = false;
        this.m_currentRow = 0L;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_currentMessagingContext.closeOperation();
        this.m_currentMessagingContext.removeSocketCloseListener(this);
    }

    @Override
    public void deleteRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public int getFetchSize() throws ErrorException {
        return this.m_fetchSize;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
            this.m_currentRow = 0L;
        } else {
            ++this.m_currentRow;
        }
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            if (this.hasMoreRows()) {
                return this.m_currentMessagingContext.doMoveToNextRow();
            }
            return false;
        }
        catch (Exception ex) {
            LogUtilities.logError(ex, this.m_log);
            throw this.buildError(ex);
        }
    }

    @Override
    public void onFinishRowUpdate() {
    }

    @Override
    public void onStartRowUpdate() {
    }

    @Override
    public void registerWarningListener(IWarningListener listener) {
        this.m_warningListener = listener;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setCursorType(CursorType cursorType) throws ErrorException {
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws ErrorException {
        this.m_fetchSize = fetchSize;
    }

    @Override
    public boolean writeData(int column, DataWrapper data, long offset, boolean isDefault) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    protected long getCurrentRow() {
        return this.m_currentRow;
    }

    @Override
    public void socketClosed(ErrorException exception) {
        this.m_fatalException = exception;
    }

    @Override
    public boolean supportsHasMoreRows() {
        return true;
    }

    private ErrorException buildError(Exception ex) {
        if (null != this.m_fatalException) {
            return this.m_fatalException;
        }
        if (ex instanceof ErrorException) {
            return (ErrorException)ex;
        }
        ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
        err.initCause(ex);
        return err;
    }
}

