/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;

public class PGMetadatSourceFromQuery
extends PGResultSet
implements IMetadataSource {
    private MetadataSourceID m_metadatasourceId = null;

    public PGMetadatSourceFromQuery(MetadataSourceID metadataSourceId, PGMessagingContext contexts, int batchIndex, ILogger logger) {
        super(contexts, logger);
        this.m_metadatasourceId = metadataSourceId;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag columnTag, long offset, long maxSize, DataWrapper data) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[]{columnTag, offset, maxSize});
        switch (this.m_metadatasourceId) {
            case CATALOG_ONLY: {
                switch (columnTag) {
                    case CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
            case CATALOG_SCHEMA_ONLY: {
                switch (columnTag) {
                    case CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                    case SCHEMA_NAME: {
                        return super.getData(1, offset, maxSize, data);
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
            case SCHEMA_ONLY: {
                switch (columnTag) {
                    case CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                    case SCHEMA_NAME: {
                        return super.getData(1, offset, maxSize, data);
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
            case TABLES: {
                switch (columnTag) {
                    case CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                    case SCHEMA_NAME: {
                        return super.getData(1, offset, maxSize, data);
                    }
                    case TABLE_NAME: {
                        return super.getData(2, offset, maxSize, data);
                    }
                    case TABLE_TYPE: {
                        return super.getData(3, offset, maxSize, data);
                    }
                    case REMARKS: {
                        return super.getData(4, offset, maxSize, data);
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
            case COLUMNS: {
                switch (columnTag) {
                    case CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                    case SCHEMA_NAME: {
                        return super.getData(1, offset, maxSize, data);
                    }
                    case TABLE_NAME: {
                        return super.getData(2, offset, maxSize, data);
                    }
                    case COLUMN_NAME: {
                        return super.getData(3, offset, maxSize, data);
                    }
                    case DATA_TYPE: {
                        return super.getData(4, offset, maxSize, data);
                    }
                    case DATA_TYPE_NAME: {
                        return super.getData(5, offset, maxSize, data);
                    }
                    case COLUMN_SIZE: {
                        return super.getData(6, offset, maxSize, data);
                    }
                    case BUFFER_LENGTH: {
                        return super.getData(7, offset, maxSize, data);
                    }
                    case DECIMAL_DIGITS: {
                        return super.getData(8, offset, maxSize, data);
                    }
                    case NUM_PREC_RADIX: {
                        return super.getData(9, offset, maxSize, data);
                    }
                    case NULLABLE: {
                        return super.getData(10, offset, maxSize, data);
                    }
                    case REMARKS: {
                        return super.getData(11, offset, maxSize, data);
                    }
                    case COLUMN_DEF: {
                        return super.getData(12, offset, maxSize, data);
                    }
                    case SQL_DATA_TYPE: {
                        return super.getData(13, offset, maxSize, data);
                    }
                    case SQL_DATETIME_SUB: {
                        return super.getData(14, offset, maxSize, data);
                    }
                    case CHAR_OCTET_LENGTH: {
                        return super.getData(15, offset, maxSize, data);
                    }
                    case ORDINAL_POSITION: {
                        return super.getData(16, offset, maxSize, data);
                    }
                    case IS_NULLABLE: {
                        return super.getData(17, offset, maxSize, data);
                    }
                    case IS_AUTOINCREMENT: {
                        data.setVarChar("NO");
                        return false;
                    }
                    case IS_GENERATEDCOLUMN: {
                        data.setVarChar("");
                        return false;
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
            case FOREIGN_KEYS: {
                switch (columnTag) {
                    case PRIMARY_KEY_CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                    case PRIMARY_KEY_SCHEMA_NAME: {
                        return super.getData(1, offset, maxSize, data);
                    }
                    case PRIMARY_KEY_TABLE_NAME: {
                        return super.getData(2, offset, maxSize, data);
                    }
                    case PRIMARY_KEY_COLUMN_NAME: {
                        return super.getData(3, offset, maxSize, data);
                    }
                    case FOREIGN_KEY_CATALOG_NAME: {
                        return super.getData(4, offset, maxSize, data);
                    }
                    case FOREIGN_KEY_SCHEMA_NAME: {
                        return super.getData(5, offset, maxSize, data);
                    }
                    case FOREIGN_KEY_TABLE_NAME: {
                        return super.getData(6, offset, maxSize, data);
                    }
                    case FOREIGN_KEY_COLUMN_NAME: {
                        return super.getData(7, offset, maxSize, data);
                    }
                    case KEY_SEQ: {
                        return super.getData(8, offset, maxSize, data);
                    }
                    case FOREIGN_KEY_UPDATE_RULE: {
                        return super.getData(9, offset, maxSize, data);
                    }
                    case FOREIGN_KEY_DELETE_RULE: {
                        return super.getData(10, offset, maxSize, data);
                    }
                    case FOREIGN_KEY_NAME: {
                        return super.getData(11, offset, maxSize, data);
                    }
                    case PRIMARY_KEY_NAME: {
                        return super.getData(12, offset, maxSize, data);
                    }
                    case DEFERRABILITY: {
                        return super.getData(13, offset, maxSize, data);
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
            case PRIMARY_KEYS: {
                switch (columnTag) {
                    case PRIMARY_KEY_CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                    case PRIMARY_KEY_SCHEMA_NAME: {
                        return super.getData(1, offset, maxSize, data);
                    }
                    case PRIMARY_KEY_TABLE_NAME: {
                        return super.getData(2, offset, maxSize, data);
                    }
                    case PRIMARY_KEY_COLUMN_NAME: {
                        return super.getData(3, offset, maxSize, data);
                    }
                    case KEY_SEQ: {
                        return super.getData(4, offset, maxSize, data);
                    }
                    case PRIMARY_KEY_NAME: {
                        return super.getData(5, offset, maxSize, data);
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
            case TABLE_PRIVILEGES: {
                switch (columnTag) {
                    case CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                    case SCHEMA_NAME: {
                        return super.getData(1, offset, maxSize, data);
                    }
                    case TABLE_NAME: {
                        return super.getData(2, offset, maxSize, data);
                    }
                    case GRANTOR: {
                        return super.getData(3, offset, maxSize, data);
                    }
                    case GRANTEE: {
                        return super.getData(4, offset, maxSize, data);
                    }
                    case PRIVILEGE: {
                        return super.getData(5, offset, maxSize, data);
                    }
                    case ISGRANTABLE: {
                        return super.getData(6, offset, maxSize, data);
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
            case PROCEDURES: {
                switch (columnTag) {
                    case CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                    case SCHEMA_NAME: {
                        return super.getData(1, offset, maxSize, data);
                    }
                    case PROCEDURE_NAME: {
                        return super.getData(2, offset, maxSize, data);
                    }
                    case NUM_INPUT_PARAMS: {
                        return super.getData(3, offset, maxSize, data);
                    }
                    case NUM_OUTPUT_PARAMS: {
                        return super.getData(4, offset, maxSize, data);
                    }
                    case NUM_RESULT_SETS: {
                        return super.getData(5, offset, maxSize, data);
                    }
                    case REMARKS: {
                        return super.getData(6, offset, maxSize, data);
                    }
                    case PROCEDURE_TYPE: {
                        return super.getData(7, offset, maxSize, data);
                    }
                    case SPECIFIC_NAME: {
                        return super.getData(8, offset, maxSize, data);
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
            case PROCEDURE_COLUMNS: {
                switch (columnTag) {
                    case CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                    case SCHEMA_NAME: {
                        return super.getData(1, offset, maxSize, data);
                    }
                    case PROCEDURE_NAME: {
                        return super.getData(2, offset, maxSize, data);
                    }
                    case COLUMN_NAME: {
                        return super.getData(3, offset, maxSize, data);
                    }
                    case PROCEDURE_COLUMN_TYPE: {
                        return super.getData(4, offset, maxSize, data);
                    }
                    case DATA_TYPE: {
                        return super.getData(5, offset, maxSize, data);
                    }
                    case DATA_TYPE_NAME: {
                        return super.getData(6, offset, maxSize, data);
                    }
                    case COLUMN_SIZE: {
                        return super.getData(7, offset, maxSize, data);
                    }
                    case BUFFER_LENGTH: {
                        return super.getData(8, offset, maxSize, data);
                    }
                    case DECIMAL_DIGITS: {
                        return super.getData(9, offset, maxSize, data);
                    }
                    case NUM_PREC_RADIX: {
                        return super.getData(10, offset, maxSize, data);
                    }
                    case NULLABLE: {
                        return super.getData(11, offset, maxSize, data);
                    }
                    case REMARKS: {
                        return super.getData(12, offset, maxSize, data);
                    }
                    case COLUMN_DEF: {
                        return super.getData(13, offset, maxSize, data);
                    }
                    case SQL_DATA_TYPE: {
                        return super.getData(14, offset, maxSize, data);
                    }
                    case SQL_DATETIME_SUB: {
                        return super.getData(15, offset, maxSize, data);
                    }
                    case CHAR_OCTET_LENGTH: {
                        return super.getData(16, offset, maxSize, data);
                    }
                    case ORDINAL_POSITION: {
                        return super.getData(17, offset, maxSize, data);
                    }
                    case IS_NULLABLE: {
                        return super.getData(18, offset, maxSize, data);
                    }
                    case SPECIFIC_NAME: {
                        return super.getData(19, offset, maxSize, data);
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
            case FUNCTIONS_JDBC4: {
                switch (columnTag) {
                    case CATALOG_NAME: {
                        return super.getData(0, offset, maxSize, data);
                    }
                    case SCHEMA_NAME: {
                        return super.getData(1, offset, maxSize, data);
                    }
                    case PROCEDURE_NAME: {
                        return super.getData(2, offset, maxSize, data);
                    }
                    case REMARKS: {
                        return super.getData(3, offset, maxSize, data);
                    }
                    case PROCEDURE_TYPE: {
                        return super.getData(4, offset, maxSize, data);
                    }
                    case SPECIFIC_NAME: {
                        return super.getData(5, offset, maxSize, data);
                    }
                }
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_ID.name(), new String[]{this.m_metadatasourceId.toString()}, ExceptionType.DEFAULT);
    }

    @Override
    public boolean moveToNextRow() {
        boolean result = false;
        try {
            result = super.moveToNextRow();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
        return result;
    }
}

