/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.value;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.amazon.sqlengine.dsiext.dataengine.CustomScalarFunction;
import com.amazon.sqlengine.dsiext.dataengine.IColumnInfo;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AECustomScalarFn
extends AEValueExpr {
    private CustomScalarFunction m_customScalarFn;
    private AEValueExprList m_arguments;
    private List<IColumn> m_inputMetadata;
    private ColumnMetadata m_metadata;

    public AECustomScalarFn(CustomScalarFunction customScalarFunction, AEValueExprList aEValueExprList) throws SQLEngineException {
        if (null == customScalarFunction) {
            throw new NullPointerException();
        }
        this.m_customScalarFn = customScalarFunction;
        this.m_arguments = aEValueExprList;
        aEValueExprList.setParent(this);
        try {
            this.initializeColumn(true);
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AECustomScalarFn copy() {
        try {
            return new AECustomScalarFn(this.m_customScalarFn, this.m_arguments.copy());
        }
        catch (SQLEngineException sQLEngineException) {
            throw new AssertionError();
        }
    }

    public AEValueExprList getArguments() {
        return this.m_arguments;
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return new AbstractList<AEValueExprList>(){

            @Override
            public AEValueExprList get(int n) {
                if (0 == n) {
                    return AECustomScalarFn.this.getArguments();
                }
                throw new IndexOutOfBoundsException("" + n);
            }

            @Override
            public int size() {
                return 1;
            }
        }.iterator();
    }

    @Override
    public IColumn getColumn() {
        assert (null != this.m_metadata);
        return this.m_metadata;
    }

    public CustomScalarFunction getDSICustomScalarFn() {
        return this.m_customScalarFn;
    }

    public List<IColumn> getInputMetadata() {
        assert (null != this.m_inputMetadata);
        return this.m_inputMetadata;
    }

    @Override
    public String getLogString() {
        return "AECustomScalarFn: " + this.m_customScalarFn.getName();
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AECustomScalarFn)) {
            return false;
        }
        AECustomScalarFn aECustomScalarFn = (AECustomScalarFn)iAENode;
        return this.m_customScalarFn == aECustomScalarFn.m_customScalarFn && this.m_arguments.isEquivalent(aECustomScalarFn.m_arguments);
    }

    @Override
    public void updateColumn() throws ErrorException {
        this.initializeColumn(false);
    }

    private void initializeColumn(boolean bl) throws ErrorException {
        CustomScalarFunction customScalarFunction = this.m_customScalarFn;
        int n = this.m_arguments.getNumChildren();
        List<IColumnInfo> list = this.columnInfoFromArguments();
        customScalarFunction.updateMetadata(list, bl);
        List<IColumn> list2 = customScalarFunction.getInputMetadata();
        if (null == list2 || n != list2.size()) {
            throw new RuntimeException("");
        }
        IColumn iColumn = customScalarFunction.getOutputMetadata();
        if (null == iColumn) {
            throw new RuntimeException("");
        }
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>(n);
        for (IColumn iColumn2 : list2) {
            arrayList.add(ColumnMetadata.copyOf(iColumn2));
        }
        this.m_inputMetadata = arrayList;
        this.m_metadata = ColumnMetadata.copyOf(iColumn);
    }

    private List<IColumnInfo> columnInfoFromArguments() {
        AEValueExprList aEValueExprList = this.getArguments();
        int n = aEValueExprList.getNumChildren();
        ArrayList<IColumnInfo> arrayList = new ArrayList<IColumnInfo>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)aEValueExprList.getChild(i)));
        }
        return arrayList;
    }
}

