/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.etree.ETCancelState;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.ETResourceManager;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.statement.ETQuery;
import com.amazon.sqlengine.executor.etree.util.RegisterWarningListenerUtil;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.InvalidOperationException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETResultSet
implements IResultSet {
    private final ArrayList<IColumn> m_columns;
    private boolean m_isCursorSet;
    private int m_fetchSize = 0;
    private IWarningListener m_warningListener = null;
    private ETRelationalExpr m_etRelation;
    private ETResourceManager m_rscManager;
    private final ETCancelState m_cancelState;

    public ETResultSet(ETQuery eTQuery, ETResourceManager eTResourceManager, ETCancelState eTCancelState) {
        this.m_etRelation = eTQuery.getOperand();
        this.m_isCursorSet = false;
        this.m_rscManager = eTResourceManager;
        this.m_columns = new ArrayList(this.m_etRelation.getColumnCount());
        this.m_cancelState = eTCancelState;
        for (int i = 0; i < this.m_etRelation.getColumnCount(); ++i) {
            this.m_columns.add(this.m_etRelation.getColumn(i));
        }
    }

    @Override
    public void appendRow() throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Append row is not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_cancelState.cancel();
        ETResultSet eTResultSet = this;
        synchronized (eTResultSet) {
            try {
                this.m_etRelation.close();
                this.m_isCursorSet = false;
            }
            finally {
                this.m_rscManager.free();
            }
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        this.close();
    }

    @Override
    public void deleteRow() throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Delete row is not implemented");
    }

    @Override
    public synchronized boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        if (!this.m_isCursorSet) {
            throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{"getData() called when the cursor is not set."});
        }
        if (this.m_cancelState.isCanceled()) {
            throw SQLEngineExceptionFactory.operationCanceledException();
        }
        ETDataRequest eTDataRequest = new ETDataRequest(l, l2, this.m_columns.get(n));
        boolean bl = this.m_etRelation.retrieveData(n, eTDataRequest);
        eTDataRequest.getData().retrieveData(dataWrapper);
        return bl;
    }

    @Override
    public int getFetchSize() throws ErrorException {
        return this.m_fetchSize;
    }

    @Override
    public synchronized long getRowCount() throws ErrorException {
        return this.m_etRelation.getRowCount();
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        return this.m_columns;
    }

    public IWarningListener getWarningListner() {
        return this.m_warningListener;
    }

    @Override
    public final boolean hasMoreRows() throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("IResult.hasMoreRows()");
    }

    @Override
    public boolean hasRowCount() {
        try {
            return -1L != this.getRowCount();
        }
        catch (ErrorException errorException) {
            return false;
        }
    }

    @Override
    public synchronized boolean moveToNextRow() throws ErrorException {
        if (!this.m_isCursorSet) {
            throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{"moveToNextRow() called when the cursor is not set."});
        }
        if (this.m_cancelState.isCanceled()) {
            throw SQLEngineExceptionFactory.operationCanceledException();
        }
        return this.m_etRelation.move();
    }

    @Override
    public void onFinishRowUpdate() {
    }

    @Override
    public void onStartRowUpdate() {
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        RegisterWarningListenerUtil.registerWarningListener(iWarningListener, this.m_etRelation);
        this.m_warningListener = iWarningListener;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public synchronized void setCursorType(CursorType cursorType) throws ErrorException {
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
        try {
            this.m_rscManager.allocate();
            this.m_etRelation.open(cursorType);
            this.m_isCursorSet = true;
        }
        catch (ErrorException errorException) {
            this.m_rscManager.free();
            throw errorException;
        }
        catch (RuntimeException runtimeException) {
            this.m_rscManager.free();
            throw runtimeException;
        }
        catch (Error error) {
            this.m_rscManager.free();
            throw error;
        }
    }

    @Override
    public void setFetchSize(int n) throws ErrorException {
        this.m_fetchSize = n;
    }

    @Override
    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("Updateable resultset");
    }

    @Override
    public final boolean supportsHasMoreRows() {
        return false;
    }
}

