/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNode;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETTable
extends ETRelationalExpr {
    protected final DSIExtJResultSet m_table;
    private boolean m_isOpen;
    private boolean m_wasLastMoveSuccess;
    private final ArrayList<? extends IColumn> m_selectColumns;

    public ETTable(boolean[] blArray, DSIExtJResultSet dSIExtJResultSet) throws ErrorException {
        super(blArray);
        if (null == dSIExtJResultSet) {
            throw new NullPointerException("table is null.");
        }
        this.m_table = dSIExtJResultSet;
        this.m_isOpen = false;
        this.m_wasLastMoveSuccess = false;
        this.m_selectColumns = this.m_table.getSelectColumns();
    }

    public void appendRow() throws ErrorException {
        this.m_table.appendRow();
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void close() {
        try {
            this.m_table.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
        this.m_isOpen = false;
    }

    public void deleteRow() throws ErrorException {
        this.m_table.deleteRow();
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_selectColumns.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_selectColumns.size();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_table.getRowCount();
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpen;
    }

    public DSIExtJResultSet getUnderlyingTable() {
        return this.m_table;
    }

    public void onStartDMLBatch(DSIExtJResultSet.DMLType dMLType, long l) throws ErrorException {
        this.m_table.onStartDMLBatch(dMLType, l);
    }

    public void onStartRowUpdate() {
        this.m_table.onStartRowUpdate();
    }

    public void onFinishDMLBatch() throws ErrorException {
        this.m_table.onFinishDMLBatch();
    }

    public void onFinishRowUpdate() throws ErrorException {
        this.m_table.onFinishRowUpdate();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        this.m_table.reset();
        this.m_table.setCursorType(cursorType);
        this.m_isOpen = true;
    }

    @Override
    public void reset() throws ErrorException {
        this.m_table.reset();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        DataWrapper dataWrapper = new DataWrapper();
        boolean bl = this.m_table.getData(n, eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), dataWrapper);
        eTDataRequest.getData().setValue(dataWrapper);
        return bl;
    }

    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        return this.m_table.writeData(n, dataWrapper, l, bl);
    }

    @Override
    protected boolean doMove() throws ErrorException {
        this.m_wasLastMoveSuccess = this.m_table.moveToNextRow();
        return this.m_wasLastMoveSuccess;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }
}

