/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.relation.join;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.IWarningSource;
import com.amazon.sqlengine.executor.etree.ETBoolean;
import com.amazon.sqlengine.executor.etree.ETCancelState;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNode;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.IMemManagerAgent;
import com.amazon.sqlengine.executor.etree.IMemoryConsumer;
import com.amazon.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.amazon.sqlengine.executor.etree.bool.ETTrue;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.relation.join.ETJoinedUnitWrapper;
import com.amazon.sqlengine.executor.etree.relation.join.IJoinAlgorithmAdapter;
import com.amazon.sqlengine.executor.etree.relation.join.IJoinUnit;
import com.amazon.support.IWarningListener;
import com.amazon.support.Pair;
import com.amazon.support.exceptions.ErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETConditionedJoin
extends ETRelationalExpr
implements IMemoryConsumer,
IWarningSource {
    private ETBooleanExpr m_joinCondition;
    private ETJoinedUnitWrapper m_leftJoinedUnitWrapper;
    private ETJoinedUnitWrapper m_rightJoinedUnitWrapper;
    private IJoinUnit m_leftUnit;
    private IJoinUnit m_rightUnit;
    private boolean m_isOpen;
    private ETRelationalExpr m_leftRelation;
    private ETRelationalExpr m_rightRelation;
    private final IJoinAlgorithmAdapter m_joinAlgorithm;
    private State m_state;
    private final ETCancelState m_cancelState;

    private ETConditionedJoin(ETBooleanExpr eTBooleanExpr, ETJoinedUnitWrapper eTJoinedUnitWrapper, ETJoinedUnitWrapper eTJoinedUnitWrapper2, ETRelationalExpr eTRelationalExpr, ETRelationalExpr eTRelationalExpr2, IJoinAlgorithmAdapter iJoinAlgorithmAdapter, ETCancelState eTCancelState, boolean[] blArray) {
        super(blArray);
        this.m_joinCondition = eTBooleanExpr;
        this.m_leftJoinedUnitWrapper = eTJoinedUnitWrapper;
        this.m_rightJoinedUnitWrapper = eTJoinedUnitWrapper2;
        this.m_leftRelation = eTRelationalExpr;
        this.m_rightRelation = eTRelationalExpr2;
        this.m_joinAlgorithm = iJoinAlgorithmAdapter;
        this.m_isOpen = false;
        this.m_cancelState = eTCancelState;
        this.initialize();
    }

    private void initialize() {
        this.m_leftUnit = null;
        this.m_rightUnit = null;
        this.m_state = null;
    }

    @Override
    public void close() {
        this.m_joinAlgorithm.closeRelations();
        if (null != this.m_leftJoinedUnitWrapper) {
            this.m_leftJoinedUnitWrapper.close();
        }
        if (null != this.m_rightJoinedUnitWrapper) {
            this.m_rightJoinedUnitWrapper.close();
        }
        this.m_isOpen = false;
        this.m_state = null;
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpen;
    }

    @Override
    public void reset() throws ErrorException {
        try {
            this.m_joinAlgorithm.reset();
            this.initialize();
            this.m_state = State.UNINITIALIZED;
        }
        catch (ErrorException errorException) {
            this.close();
            throw errorException;
        }
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 3;
    }

    @Override
    public IColumn getColumn(int n) {
        if (n >= this.m_leftRelation.getColumnCount()) {
            return this.m_rightRelation.getColumn(n - this.m_leftRelation.getColumnCount());
        }
        return this.m_leftRelation.getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_leftRelation.getColumnCount() + this.m_rightRelation.getColumnCount();
    }

    @Override
    public long getRowCount() {
        return -1L;
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        try {
            this.m_state = State.UNINITIALIZED;
            this.m_joinAlgorithm.open(cursorType);
            this.m_isOpen = true;
        }
        catch (ErrorException errorException) {
            this.close();
            throw errorException;
        }
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        try {
            boolean bl;
            int n2;
            if (this.m_leftUnit == null || this.m_rightUnit == null) {
                throw new IllegalStateException("Retrieving while no data left.");
            }
            boolean bl2 = n < this.m_leftRelation.getColumnCount();
            int n3 = n2 = bl2 ? n : n - this.m_leftRelation.getColumnCount();
            if (this.m_state == State.JOINING) {
                if (bl2) {
                    return this.m_leftUnit.retrieveData(n, eTDataRequest);
                }
                return this.m_rightUnit.retrieveData(n2, eTDataRequest);
            }
            if (this.m_state == State.MASTER_OUTER) {
                boolean bl3;
                boolean bl4 = bl3 = bl2 == this.m_joinAlgorithm.isMasterJoinUnitOnLeft();
                if (bl3) {
                    return this.getMasterUnit().retrieveData(n2, eTDataRequest);
                }
                eTDataRequest.getData().setNull();
                return false;
            }
            boolean bl5 = bl = bl2 != this.m_joinAlgorithm.isMasterJoinUnitOnLeft();
            if (bl) {
                return this.getSlaveUnit().retrieveData(n2, eTDataRequest);
            }
            eTDataRequest.getData().setNull();
            return false;
        }
        catch (ErrorException errorException) {
            this.close();
            throw errorException;
        }
        catch (Throwable throwable) {
            this.close();
            throw SQLEngineExceptionFactory.convertRuntimeException(throwable);
        }
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= 3) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        if (n == 0) {
            return this.m_leftRelation;
        }
        if (n == 1) {
            return this.m_rightRelation;
        }
        return this.m_joinCondition;
    }

    @Override
    protected boolean doMove() throws ErrorException {
        try {
            block9: while (true) {
                switch (this.m_state) {
                    case UNINITIALIZED: {
                        this.m_cancelState.checkCancel();
                        Pair<? extends IJoinUnit, ? extends IJoinUnit> pair = this.m_joinAlgorithm.loadNextJoinUnit();
                        if (pair == null) {
                            return false;
                        }
                        this.m_leftUnit = pair.key();
                        this.m_rightUnit = pair.value();
                        this.m_leftJoinedUnitWrapper.setJoinUnit(this.m_leftUnit);
                        this.m_rightJoinedUnitWrapper.setJoinUnit(this.m_rightUnit);
                        this.m_state = State.UNIT_LOADED;
                        continue block9;
                    }
                    case UNIT_LOADED: 
                    case MASTER_OUTER: {
                        boolean bl = this.m_joinAlgorithm.moveMaster();
                        boolean bl2 = this.m_joinAlgorithm.isOuterRow();
                        if (bl) {
                            if (bl2) {
                                this.m_state = State.MASTER_OUTER;
                                return true;
                            }
                            this.m_state = State.JOINING;
                            this.m_joinAlgorithm.seekSlave();
                            continue block9;
                        }
                        if (bl2) {
                            this.m_state = State.SLAVE_OUTER;
                            continue block9;
                        }
                        this.m_leftUnit.close();
                        this.m_rightUnit.close();
                        this.m_leftUnit = null;
                        this.m_rightUnit = null;
                        this.m_state = State.UNINITIALIZED;
                        continue block9;
                    }
                    case JOINING: {
                        while (this.m_joinAlgorithm.moveSlave()) {
                            if (this.m_joinCondition.evaluate() != ETBoolean.SQL_BOOLEAN_TRUE) continue;
                            this.m_joinAlgorithm.match();
                            return true;
                        }
                        this.m_state = State.UNIT_LOADED;
                        continue block9;
                    }
                    case SLAVE_OUTER: {
                        if (this.m_joinAlgorithm.moveSlave()) {
                            assert (this.m_joinAlgorithm.isOuterRow());
                            return true;
                        }
                        this.m_leftUnit.close();
                        this.m_rightUnit.close();
                        this.m_leftUnit = null;
                        this.m_rightUnit = null;
                        this.m_state = State.UNINITIALIZED;
                        continue block9;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknow state.");
        }
        catch (ErrorException errorException) {
            this.close();
            throw errorException;
        }
        catch (Throwable throwable) {
            this.close();
            throw SQLEngineExceptionFactory.convertRuntimeException(throwable);
        }
    }

    private IJoinUnit getMasterUnit() {
        if (this.m_joinAlgorithm.isMasterJoinUnitOnLeft()) {
            return this.m_leftUnit;
        }
        return this.m_rightUnit;
    }

    private IJoinUnit getSlaveUnit() {
        if (this.m_joinAlgorithm.isMasterJoinUnitOnLeft()) {
            return this.m_rightUnit;
        }
        return this.m_leftUnit;
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_joinAlgorithm.registerManagerAgent(iMemManagerAgent);
    }

    @Override
    public long assign(long l) {
        return this.m_joinAlgorithm.assign(l);
    }

    @Override
    public long getRequiredMemory() {
        return this.m_joinAlgorithm.getRequiredMemory();
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_joinAlgorithm.registerWarningListener(iWarningListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNINITIALIZED,
        UNIT_LOADED,
        JOINING,
        SLAVE_OUTER,
        MASTER_OUTER;

    }

    public static class Builder {
        ETBooleanExpr m_joinCondition;
        ETJoinedUnitWrapper m_leftJoinedUnitWrapper;
        ETJoinedUnitWrapper m_rightJoinedUnitWrapper;
        ETRelationalExpr m_leftRelation;
        ETRelationalExpr m_rightRelation;
        IJoinAlgorithmAdapter m_joinAlgorithm;
        private boolean[] m_dataNeeded;
        private final ETCancelState m_cancelState;

        public Builder(ETRelationalExpr eTRelationalExpr, ETRelationalExpr eTRelationalExpr2, ETCancelState eTCancelState, boolean[] blArray) {
            if (eTRelationalExpr == null || eTRelationalExpr2 == null || eTCancelState == null) {
                throw new NullPointerException("Null set for the ETConditionedJoin builer.");
            }
            this.m_leftRelation = eTRelationalExpr;
            this.m_rightRelation = eTRelationalExpr2;
            boolean[] blArray2 = new boolean[this.m_leftRelation.getColumnCount()];
            for (int i = 0; i < blArray2.length; ++i) {
                if (!this.m_leftRelation.getDataNeeded(i) && !blArray[i]) continue;
                blArray2[i] = true;
            }
            boolean[] blArray3 = new boolean[this.m_rightRelation.getColumnCount()];
            for (int i = 0; i < blArray3.length; ++i) {
                if (!this.m_rightRelation.getDataNeeded(i) && !blArray[i + this.m_leftRelation.getColumnCount()]) continue;
                blArray3[i] = true;
            }
            this.m_leftJoinedUnitWrapper = new ETJoinedUnitWrapper(eTRelationalExpr, blArray2);
            this.m_rightJoinedUnitWrapper = new ETJoinedUnitWrapper(eTRelationalExpr2, blArray3);
            this.m_joinCondition = new ETTrue();
            this.m_dataNeeded = (boolean[])blArray.clone();
            this.m_cancelState = eTCancelState;
        }

        public ETRelationalExpr getLeftRelationWrapper() {
            return this.m_leftJoinedUnitWrapper;
        }

        public ETRelationalExpr getRightRelationWrapper() {
            return this.m_rightJoinedUnitWrapper;
        }

        public void setJoinAlgorithm(IJoinAlgorithmAdapter iJoinAlgorithmAdapter) {
            this.m_joinAlgorithm = iJoinAlgorithmAdapter;
        }

        public void setJoinCondition(ETBooleanExpr eTBooleanExpr) {
            if (eTBooleanExpr != null) {
                this.m_joinCondition = eTBooleanExpr;
            }
        }

        public ETConditionedJoin build() {
            if (this.m_joinAlgorithm == null) {
                throw new NullPointerException("Join algorithm can not be null.");
            }
            return new ETConditionedJoin(this.m_joinCondition, this.m_leftJoinedUnitWrapper, this.m_rightJoinedUnitWrapper, this.m_leftRelation, this.m_rightRelation, this.m_joinAlgorithm, this.m_cancelState, this.m_dataNeeded);
        }
    }
}

