/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.etree.temptable.InMemTable;
import com.amazon.sqlengine.executor.etree.temptable.RowBlock;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryFile;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.amazon.support.ILogger;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;

public class BlockConverter {
    private InMemTable m_table;
    private int m_curRow;

    public BlockConverter(IColumn[] iColumnArray, TemporaryTableBuilder.TemporaryTableProperties temporaryTableProperties, ILogger iLogger, boolean[] blArray) throws ErrorException {
        int n = (int)(temporaryTableProperties.m_blockSize / temporaryTableProperties.m_rowSize / 10L) + 1;
        this.m_table = new InMemTable(iColumnArray, temporaryTableProperties.m_maxDataLen, n, blArray, iLogger);
        this.m_curRow = -1;
    }

    public boolean appendRow() {
        this.m_curRow = this.m_table.appendRow();
        return this.m_curRow >= 0;
    }

    public void setNull(int n) {
        this.m_table.setNull(this.m_curRow, n);
    }

    public void setBigInt(int n, long l) {
        this.m_table.setBigInt(this.m_curRow, n, l);
    }

    public void setExactNum(int n, BigDecimal bigDecimal) {
        this.m_table.setExactNum(this.m_curRow, n, bigDecimal);
    }

    public void setDouble(int n, double d) {
        this.m_table.setDouble(this.m_curRow, n, d);
    }

    public void setReal(int n, float f) {
        this.m_table.setReal(this.m_curRow, n, f);
    }

    public void setBoolean(int n, boolean bl) {
        this.m_table.setBoolean(this.m_curRow, n, bl);
    }

    public void setString(int n, String string) {
        this.m_table.setString(this.m_curRow, n, string);
    }

    public void setDate(int n, Date date) {
        this.m_table.setDate(this.m_curRow, n, date);
    }

    public void setTime(int n, Time time) {
        this.m_table.setTime(this.m_curRow, n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        this.m_table.setTimestamp(this.m_curRow, n, timestamp);
    }

    public void setFileMarker(int n, TemporaryFile.FileMarker fileMarker) {
        this.m_table.setFileMarker(this.m_curRow, n, fileMarker);
    }

    public void setGuid(int n, UUID uUID) {
        this.m_table.setGuid(this.m_curRow, n, uUID);
    }

    public void setInteger(int n, int n2) {
        this.m_table.setInteger(this.m_curRow, n, n2);
    }

    public void setSmallInt(int n, short s) {
        this.m_table.setSmallInt(this.m_curRow, n, s);
    }

    public void setTinyInt(int n, byte by) {
        this.m_table.setTinyInt(this.m_curRow, n, by);
    }

    public void setBytes(int n, byte[] byArray) {
        this.m_table.setBytes(this.m_curRow, n, byArray);
    }

    public RowBlock toRowBlock() {
        this.m_curRow = -1;
        RowBlock rowBlock = this.m_table.toRowBlock();
        this.m_table.clear();
        return rowBlock;
    }

    public int getNumRows() {
        return this.m_table.getNumRows();
    }

    public void setMemLimit(long l) {
        this.m_table.setMemLimit(l);
    }

    public int getMemOverhead() {
        return this.m_table.getMemOverhead();
    }

    public void reset() {
        this.m_table.clear();
        this.m_table.setMemLimit(0L);
    }
}

