/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable.column;

import com.amazon.sqlengine.executor.etree.temptable.column.BitsUtil;
import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.amazon.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.amazon.sqlengine.executor.etree.temptable.column.IColumnSlice;
import com.amazon.sqlengine.executor.etree.util.CompressionUtil;

public final class SmallIntColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = 3397388423848434484L;
    private short[] m_data;
    private byte[] m_nullInd;
    private final int m_columnNumber;
    private final boolean m_isSigned;

    public SmallIntColumnSlice(int n, int n2, boolean bl) {
        this.m_data = new short[n];
        this.m_nullInd = new byte[(n + 7) / 8];
        this.m_columnNumber = n2;
        this.m_isSigned = bl;
    }

    public int columnNumber() {
        return this.m_columnNumber;
    }

    public boolean isNull(int n) {
        return BitsUtil.isSet(this.m_nullInd, n);
    }

    public void setNull(int n) {
        BitsUtil.setBit(this.m_nullInd, n);
    }

    public short getSmallInt(int n) {
        return this.m_data[n];
    }

    public long getBigInt(int n) {
        return CompressionUtil.getSmallIntAsInteger(this.m_data[n], this.m_isSigned);
    }

    public double getDouble(int n) {
        return CompressionUtil.getSmallIntAsInteger(this.m_data[n], this.m_isSigned);
    }

    public float getReal(int n) {
        return CompressionUtil.getSmallIntAsInteger(this.m_data[n], this.m_isSigned);
    }

    public int getInteger(int n) {
        return CompressionUtil.getSmallIntAsInteger(this.m_data[n], this.m_isSigned);
    }

    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.SMALLINT;
    }

    public void setSmallInt(int n, short s) {
        this.m_data[n] = s;
        BitsUtil.clearBit(this.m_nullInd, n);
    }

    public int size() {
        return this.m_data.length;
    }

    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        SmallIntColumnSlice smallIntColumnSlice = (SmallIntColumnSlice)iColumnSlice;
        System.arraycopy(smallIntColumnSlice.m_data, n, this.m_data, n3, n2);
        BitsUtil.copy(this.m_nullInd, n3, n2, smallIntColumnSlice.m_nullInd, n);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return 0.0;
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return (double)javaSize.getShortSize() + (double)javaSize.getByteSize() / 8.0;
    }
}

