/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable.column;

import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.amazon.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.amazon.sqlengine.executor.etree.temptable.column.IColumnSlice;
import java.sql.Timestamp;

public final class TimestampColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = -7615131358345588142L;
    private Timestamp[] m_data;
    private final int m_columnNumber;

    public TimestampColumnSlice(int n, int n2) {
        this.m_data = new Timestamp[n];
        this.m_columnNumber = n2;
    }

    public int columnNumber() {
        return this.m_columnNumber;
    }

    public boolean isNull(int n) {
        return null == this.m_data[n];
    }

    public void setNull(int n) {
        this.m_data[n] = null;
    }

    public Timestamp getTimestamp(int n) {
        return this.m_data[n];
    }

    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.TIMESTAMP;
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        this.m_data[n] = timestamp;
    }

    public int size() {
        return this.m_data.length;
    }

    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        TimestampColumnSlice timestampColumnSlice = (TimestampColumnSlice)iColumnSlice;
        System.arraycopy(timestampColumnSlice.m_data, n, this.m_data, n3, n2);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectShellSize() + javaSize.getLongSize() + javaSize.getIntSize() + javaSize.getObjectRefSize();
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectRefSize();
    }
}

