/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.scalar;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.IWarningListener;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETUCaseFn
extends ETScalarFn {
    public ETUCaseFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == this.getNumChildren());
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (iColumn.getTypeMetadata().isCharacterType());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0, eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string = iSqlDataWrapper.getChar();
        boolean bl = this.hasMoreData(0);
        long l = eTDataRequest.getOffset() / 2L;
        long l2 = this.getResultMetadata().getColumnLength();
        if (l + (long)string.length() > l2) {
            bl = false;
            int n = (int)(l2 - l);
            string = string.substring(0, n);
            IWarningListener iWarningListener = this.getWarningListener();
            iWarningListener.postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1, -1));
        }
        eTDataRequest.getData().setChar(string.toUpperCase());
        return bl;
    }
}

