/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.materializer;

import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETable;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEInsertDefaults;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AESetClause;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AESetClauseList;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalCache;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.relation.ETTable;
import com.amazon.sqlengine.executor.etree.relation.ETTableConstructor;
import com.amazon.sqlengine.executor.etree.statement.ETInsert;
import com.amazon.sqlengine.executor.etree.statement.ETSearchedUpdate;
import com.amazon.sqlengine.executor.etree.statement.ETSetClause;
import com.amazon.sqlengine.executor.etree.statement.ETSetClauseList;
import com.amazon.sqlengine.executor.etree.statement.RowCountStatement;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryTable;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.ETValueExprList;
import com.amazon.sqlengine.executor.materializer.ConvMaterializeUtil;
import com.amazon.sqlengine.executor.materializer.ETBoolExprMaterializer;
import com.amazon.sqlengine.executor.materializer.ETRelationalExprMaterializer;
import com.amazon.sqlengine.executor.materializer.ETTableMaterializer;
import com.amazon.sqlengine.executor.materializer.ETValueExprMaterializer;
import com.amazon.sqlengine.executor.materializer.MaterializerBase;
import com.amazon.sqlengine.executor.materializer.MaterializerContext;
import com.amazon.sqlengine.executor.queryplan.IQueryPlan;
import com.amazon.sqlengine.utilities.ExternalAlgorithmUtil;
import com.amazon.support.Pair;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETDmlMaterializer
extends MaterializerBase<RowCountStatement> {
    public ETDmlMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext) {
        super(iQueryPlan, materializerContext);
    }

    @Override
    public RowCountStatement visit(AEInsert aEInsert) throws ErrorException {
        int n;
        AETable aETable = aEInsert.getTable();
        ETTable eTTable = new ETTableMaterializer(this.getQueryPlan(), this.getContext()).visit(aETable);
        AEValueExprList aEValueExprList = aEInsert.getInsertColumns();
        ArrayList<Pair<Integer, IColumn>> arrayList = new ArrayList<Pair<Integer, IColumn>>();
        if (aEValueExprList.getNumChildren() != 0) {
            for (n = 0; n < aEValueExprList.getNumChildren(); ++n) {
                AEColumnReference aEColumnReference = (AEColumnReference)aEValueExprList.getChild(n);
                arrayList.add(new Pair<Integer, IColumn>(aEColumnReference.getColumnNum(), aEColumnReference.getColumn()));
            }
        } else {
            for (n = 0; n < aETable.getColumnCount(); ++n) {
                arrayList.add(new Pair<Integer, IColumn>(n, aETable.getBaseColumn(n)));
            }
        }
        boolean[] blArray = new boolean[aEInsert.getRelationalExpr().getColumnCount()];
        for (int i = 0; i < blArray.length; ++i) {
            if (!aEInsert.getRelationalExpr().getDataNeeded(i)) continue;
            blArray[i] = true;
        }
        ETRelationalExprMaterializer eTRelationalExprMaterializer = new ETRelationalExprMaterializer(this.getQueryPlan(), this.getContext());
        eTRelationalExprMaterializer.setErrorOnTruncate(true);
        ETRelationalExpr eTRelationalExpr = aEInsert.getRelationalExpr().acceptVisitor(eTRelationalExprMaterializer);
        if (aEInsert.isRecursive() && !this.isCursorInsensitive()) {
            eTRelationalExpr = this.cacheRelation(eTRelationalExpr, blArray, aEInsert.getRelationalExpr().getResultSetColumns(), "INSERT");
        }
        ArrayList<IColumn> arrayList2 = new ArrayList<IColumn>(arrayList.size());
        for (Pair pair : arrayList) {
            arrayList2.add((IColumn)pair.value());
        }
        eTRelationalExpr = ConvMaterializeUtil.makeNewRelationConvertNode(arrayList2, eTRelationalExpr, blArray, true, this.getContext());
        return new ETInsert(eTTable, arrayList, eTRelationalExpr, this.getContext().getParameters());
    }

    @Override
    public RowCountStatement visit(AEInsertDefaults aEInsertDefaults) throws ErrorException {
        List<IColumn> list = Collections.emptyList();
        ETTableConstructor eTTableConstructor = new ETTableConstructor(new ETValueExprList(), list, new boolean[0]);
        ETTable eTTable = new ETTableMaterializer(this.getQueryPlan(), this.getContext()).visit(aEInsertDefaults.getTable());
        List<Pair<Integer, IColumn>> list2 = Collections.emptyList();
        return new ETInsert(eTTable, list2, eTTableConstructor, this.getContext().getParameters());
    }

    @Override
    public RowCountStatement visit(AEUpdate aEUpdate) throws ErrorException {
        Object object2;
        ETRelationalExprMaterializer eTRelationalExprMaterializer = new ETRelationalExprMaterializer(this.getQueryPlan(), this.getContext());
        AETable aETable = aEUpdate.getTable();
        AESetClauseList aESetClauseList = aEUpdate.getSetClauses();
        ETTable eTTable = eTRelationalExprMaterializer.visit(aETable);
        List<IColumn> list = aEUpdate.getTable().getResultSetColumns();
        boolean bl = aEUpdate.doInsertOnRc0();
        if (bl) {
            for (Object object2 : aESetClauseList) {
                AETreeWalker aETreeWalker = new AETreeWalker(((AESetClause)object2).getRightOperand());
                while (aETreeWalker.hasNext()) {
                    AEColumnReference aEColumnReference;
                    IAENode iAENode = aETreeWalker.next();
                    if (!(iAENode instanceof AEColumnReference) || (aEColumnReference = (AEColumnReference)iAENode).getNamedRelationalExpr() != aETable) continue;
                    throw SQLEngineExceptionFactory.invalidUpsertQueryException("Table columns are referenced in the set clause");
                }
            }
        }
        ETSetClauseList eTSetClauseList = this.materializeSetClauses(aESetClauseList, list);
        object2 = aEUpdate.getUpdateCondition().acceptVisitor(new ETBoolExprMaterializer(this.getQueryPlan(), this.getContext()));
        return new ETSearchedUpdate(eTTable, eTSetClauseList, (ETBooleanExpr)object2, bl, this.getContext().getParameters());
    }

    private ETSetClauseList materializeSetClauses(AESetClauseList aESetClauseList, List<IColumn> list) throws ErrorException {
        ETValueExprMaterializer eTValueExprMaterializer = new ETValueExprMaterializer(this.getQueryPlan(), this.getContext());
        ETSetClauseList eTSetClauseList = new ETSetClauseList();
        for (AESetClause aESetClause : aESetClauseList) {
            int n = aESetClause.getLeftOperand().getColumnNum();
            ETValueExpr eTValueExpr = aESetClause.getRightOperand().acceptVisitor(eTValueExprMaterializer);
            eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, aESetClause.getRightOperand().getColumn(), list.get(n), true, this.getContext());
            eTSetClauseList.add(new ETSetClause(eTValueExpr, n));
        }
        return eTSetClauseList;
    }

    private ETRelationalExpr cacheRelation(ETRelationalExpr eTRelationalExpr, boolean[] blArray, List<IColumn> list, String string) throws ErrorException {
        ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties = this.getContext().getExternalAlgorithmProperties();
        TemporaryTableBuilder.TemporaryTableProperties temporaryTableProperties = new TemporaryTableBuilder.TemporaryTableProperties(externalAlgorithmProperties.getStorageDir(), externalAlgorithmProperties.getCellMemoryLimit(), externalAlgorithmProperties.getBlockSize(), ExternalAlgorithmUtil.calculateRowSize(list, blArray, externalAlgorithmProperties.getCellMemoryLimit()), externalAlgorithmProperties.getMaxNumOpenFiles(), externalAlgorithmProperties.getLogger(), string);
        return new ETRelationalCache(eTRelationalExpr, new TemporaryTable(list, temporaryTableProperties, blArray));
    }

    private boolean isCursorInsensitive() throws ErrorException {
        Variant variant = this.getContext().getDataEngineContext().getConnProperty(39);
        try {
            return 1L == variant.getLong();
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new AssertionError((Object)incorrectTypeException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
    }
}

