/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.logging;

import com.amazonaws.logging.AndroidLog;
import com.amazonaws.logging.ApacheCommonsLogging;
import com.amazonaws.logging.Log;
import java.util.HashMap;
import java.util.Map;

public class LogFactory {
    private static final String TAG = LogFactory.class.getSimpleName();
    private static final String APACHE_COMMONS_LOGGING_LOGFACTORY = "org.apache.commons.logging.LogFactory";
    private static Map<String, Log> logMap = new HashMap<String, Log>();

    public static synchronized Log getLog(Class clazz) {
        return LogFactory.getLog(clazz.getSimpleName());
    }

    public static synchronized Log getLog(String string) {
        Log log = logMap.get(string);
        if (log == null) {
            if (LogFactory.checkApacheCommonsLoggingExists()) {
                try {
                    log = new ApacheCommonsLogging(string);
                    logMap.put(string, log);
                }
                catch (Exception e) {
                    android.util.Log.w((String)TAG, (String)"Could not create log from org.apache.commons.logging.LogFactory", (Throwable)e);
                }
            }
            if (log == null) {
                log = new AndroidLog(string);
                logMap.put(string, log);
            }
        }
        return log;
    }

    private static boolean checkApacheCommonsLoggingExists() {
        try {
            Class<?> classObject = Class.forName(APACHE_COMMONS_LOGGING_LOGFACTORY);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (Exception ex) {
            android.util.Log.e((String)TAG, (String)ex.getMessage());
            return false;
        }
    }
}

