/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AbortedException;
import com.amazonaws.AmazonServiceException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;

public class RetryUtils {
    public static boolean isThrottlingException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        String errorCode = ase.getErrorCode();
        return "Throttling".equals(errorCode) || "ThrottlingException".equals(errorCode) || "ProvisionedThroughputExceededException".equals(errorCode);
    }

    public static boolean isRequestEntityTooLargeException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        return "Request entity too large".equals(ase.getErrorCode());
    }

    public static boolean isClockSkewError(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        String errorCode = ase.getErrorCode();
        return "RequestTimeTooSkewed".equals(errorCode) || "RequestExpired".equals(errorCode) || "InvalidSignatureException".equals(errorCode) || "SignatureDoesNotMatch".equals(errorCode);
    }

    public static boolean isInterrupted(Throwable error) {
        Throwable cause;
        if (error instanceof AbortedException) {
            return true;
        }
        return error.getCause() != null && ((cause = error.getCause()) instanceof InterruptedException || cause instanceof InterruptedIOException && !(cause instanceof SocketTimeoutException));
    }
}

