/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.event;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressReportingInputStream
extends SdkFilterInputStream {
    private static final int NOTIFICATION_THRESHOLD = 8192;
    private final ProgressListenerCallbackExecutor listenerCallbackExecutor;
    private int unnotifiedByteCount;
    private boolean fireCompletedEvent;

    public ProgressReportingInputStream(InputStream in, ProgressListenerCallbackExecutor listenerCallbackExecutor) {
        super(in);
        this.listenerCallbackExecutor = listenerCallbackExecutor;
    }

    public void setFireCompletedEvent(boolean fireCompletedEvent) {
        this.fireCompletedEvent = fireCompletedEvent;
    }

    public boolean getFireCompletedEvent() {
        return this.fireCompletedEvent;
    }

    @Override
    public int read() throws IOException {
        int data = super.read();
        if (data == -1) {
            this.notifyCompleted();
        } else {
            this.notify(1);
        }
        return data;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        ProgressEvent event = new ProgressEvent(this.unnotifiedByteCount);
        event.setEventCode(32);
        this.listenerCallbackExecutor.progressChanged(event);
        this.unnotifiedByteCount = 0;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead == -1) {
            this.notifyCompleted();
        }
        if (bytesRead != -1) {
            this.notify(bytesRead);
        }
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        if (this.unnotifiedByteCount > 0) {
            this.listenerCallbackExecutor.progressChanged(new ProgressEvent(this.unnotifiedByteCount));
            this.unnotifiedByteCount = 0;
        }
        super.close();
    }

    private void notifyCompleted() {
        if (!this.fireCompletedEvent) {
            return;
        }
        ProgressEvent event = new ProgressEvent(this.unnotifiedByteCount);
        event.setEventCode(4);
        this.unnotifiedByteCount = 0;
        this.listenerCallbackExecutor.progressChanged(event);
    }

    private void notify(int bytesRead) {
        this.unnotifiedByteCount += bytesRead;
        if (this.unnotifiedByteCount >= 8192) {
            this.listenerCallbackExecutor.progressChanged(new ProgressEvent(this.unnotifiedByteCount));
            this.unnotifiedByteCount = 0;
        }
    }
}

