/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.alexaforbusiness.model.Content;
import com.amazonaws.services.alexaforbusiness.model.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SendAnnouncementRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<Filter> roomFilters;
    private Content content;
    private Integer timeToLiveInSeconds;
    private String clientRequestToken;

    public List<Filter> getRoomFilters() {
        return this.roomFilters;
    }

    public void setRoomFilters(Collection<Filter> roomFilters) {
        if (roomFilters == null) {
            this.roomFilters = null;
            return;
        }
        this.roomFilters = new ArrayList<Filter>(roomFilters);
    }

    public SendAnnouncementRequest withRoomFilters(Filter ... roomFilters) {
        if (this.roomFilters == null) {
            this.setRoomFilters(new ArrayList<Filter>(roomFilters.length));
        }
        for (Filter ele : roomFilters) {
            this.roomFilters.add(ele);
        }
        return this;
    }

    public SendAnnouncementRequest withRoomFilters(Collection<Filter> roomFilters) {
        this.setRoomFilters(roomFilters);
        return this;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public Content getContent() {
        return this.content;
    }

    public SendAnnouncementRequest withContent(Content content) {
        this.setContent(content);
        return this;
    }

    public void setTimeToLiveInSeconds(Integer timeToLiveInSeconds) {
        this.timeToLiveInSeconds = timeToLiveInSeconds;
    }

    public Integer getTimeToLiveInSeconds() {
        return this.timeToLiveInSeconds;
    }

    public SendAnnouncementRequest withTimeToLiveInSeconds(Integer timeToLiveInSeconds) {
        this.setTimeToLiveInSeconds(timeToLiveInSeconds);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public SendAnnouncementRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoomFilters() != null) {
            sb.append("RoomFilters: ").append(this.getRoomFilters()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append(this.getContent()).append(",");
        }
        if (this.getTimeToLiveInSeconds() != null) {
            sb.append("TimeToLiveInSeconds: ").append(this.getTimeToLiveInSeconds()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendAnnouncementRequest)) {
            return false;
        }
        SendAnnouncementRequest other = (SendAnnouncementRequest)obj;
        if (other.getRoomFilters() == null ^ this.getRoomFilters() == null) {
            return false;
        }
        if (other.getRoomFilters() != null && !other.getRoomFilters().equals(this.getRoomFilters())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getTimeToLiveInSeconds() == null ^ this.getTimeToLiveInSeconds() == null) {
            return false;
        }
        if (other.getTimeToLiveInSeconds() != null && !other.getTimeToLiveInSeconds().equals(this.getTimeToLiveInSeconds())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        return other.getClientRequestToken() == null || other.getClientRequestToken().equals(this.getClientRequestToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoomFilters() == null ? 0 : this.getRoomFilters().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getTimeToLiveInSeconds() == null ? 0 : this.getTimeToLiveInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        return hashCode;
    }

    public SendAnnouncementRequest clone() {
        return (SendAnnouncementRequest)super.clone();
    }
}

