/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationinsights.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.applicationinsights.model.ConfigurationEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListConfigurationHistoryResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ConfigurationEvent> eventList;
    private String nextToken;

    public List<ConfigurationEvent> getEventList() {
        return this.eventList;
    }

    public void setEventList(Collection<ConfigurationEvent> eventList) {
        if (eventList == null) {
            this.eventList = null;
            return;
        }
        this.eventList = new ArrayList<ConfigurationEvent>(eventList);
    }

    public ListConfigurationHistoryResult withEventList(ConfigurationEvent ... eventList) {
        if (this.eventList == null) {
            this.setEventList(new ArrayList<ConfigurationEvent>(eventList.length));
        }
        for (ConfigurationEvent ele : eventList) {
            this.eventList.add(ele);
        }
        return this;
    }

    public ListConfigurationHistoryResult withEventList(Collection<ConfigurationEvent> eventList) {
        this.setEventList(eventList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListConfigurationHistoryResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventList() != null) {
            sb.append("EventList: ").append(this.getEventList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationHistoryResult)) {
            return false;
        }
        ListConfigurationHistoryResult other = (ListConfigurationHistoryResult)obj;
        if (other.getEventList() == null ^ this.getEventList() == null) {
            return false;
        }
        if (other.getEventList() != null && !other.getEventList().equals(this.getEventList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventList() == null ? 0 : this.getEventList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListConfigurationHistoryResult clone() {
        try {
            return (ListConfigurationHistoryResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

