/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.apprunner.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.apprunner.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AutoScalingConfigurationSummary JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AutoScalingConfigurationSummaryJsonUnmarshaller implements Unmarshaller<AutoScalingConfigurationSummary, JsonUnmarshallerContext> {

    public AutoScalingConfigurationSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        AutoScalingConfigurationSummary autoScalingConfigurationSummary = new AutoScalingConfigurationSummary();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("AutoScalingConfigurationArn", targetDepth)) {
                    context.nextToken();
                    autoScalingConfigurationSummary.setAutoScalingConfigurationArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AutoScalingConfigurationName", targetDepth)) {
                    context.nextToken();
                    autoScalingConfigurationSummary.setAutoScalingConfigurationName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AutoScalingConfigurationRevision", targetDepth)) {
                    context.nextToken();
                    autoScalingConfigurationSummary.setAutoScalingConfigurationRevision(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    autoScalingConfigurationSummary.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    autoScalingConfigurationSummary.setCreatedAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("HasAssociatedService", targetDepth)) {
                    context.nextToken();
                    autoScalingConfigurationSummary.setHasAssociatedService(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("IsDefault", targetDepth)) {
                    context.nextToken();
                    autoScalingConfigurationSummary.setIsDefault(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return autoScalingConfigurationSummary;
    }

    private static AutoScalingConfigurationSummaryJsonUnmarshaller instance;

    public static AutoScalingConfigurationSummaryJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new AutoScalingConfigurationSummaryJsonUnmarshaller();
        return instance;
    }
}
