/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.SessionConfiguration;

@SdkInternalApi
public class SessionConfigurationMarshaller {
    private static final MarshallingInfo<String> EXECUTIONROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionRole").build();
    private static final MarshallingInfo<String> WORKINGDIRECTORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkingDirectory").build();
    private static final MarshallingInfo<Long> IDLETIMEOUTSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdleTimeoutSeconds").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionConfiguration").build();
    private static final SessionConfigurationMarshaller instance = new SessionConfigurationMarshaller();

    public static SessionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SessionConfiguration sessionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (sessionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sessionConfiguration.getExecutionRole(), EXECUTIONROLE_BINDING);
            protocolMarshaller.marshall((Object)sessionConfiguration.getWorkingDirectory(), WORKINGDIRECTORY_BINDING);
            protocolMarshaller.marshall((Object)sessionConfiguration.getIdleTimeoutSeconds(), IDLETIMEOUTSECONDS_BINDING);
            protocolMarshaller.marshall((Object)sessionConfiguration.getEncryptionConfiguration(), ENCRYPTIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

