/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.CustomizedMetricSpecification;
import com.amazonaws.services.autoscaling.model.MetricDimension;
import com.amazonaws.services.autoscaling.model.PredefinedMetricSpecification;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.autoscaling.model.StepAdjustment;
import com.amazonaws.services.autoscaling.model.TargetTrackingConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutScalingPolicyRequestMarshaller
implements Marshaller<Request<PutScalingPolicyRequest>, PutScalingPolicyRequest> {
    public Request<PutScalingPolicyRequest> marshall(PutScalingPolicyRequest putScalingPolicyRequest) {
        TargetTrackingConfiguration targetTrackingConfiguration;
        if (putScalingPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putScalingPolicyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutScalingPolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putScalingPolicyRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)putScalingPolicyRequest.getAutoScalingGroupName()));
        }
        if (putScalingPolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)putScalingPolicyRequest.getPolicyName()));
        }
        if (putScalingPolicyRequest.getPolicyType() != null) {
            request.addParameter("PolicyType", StringUtils.fromString((String)putScalingPolicyRequest.getPolicyType()));
        }
        if (putScalingPolicyRequest.getAdjustmentType() != null) {
            request.addParameter("AdjustmentType", StringUtils.fromString((String)putScalingPolicyRequest.getAdjustmentType()));
        }
        if (putScalingPolicyRequest.getMinAdjustmentStep() != null) {
            request.addParameter("MinAdjustmentStep", StringUtils.fromInteger((Integer)putScalingPolicyRequest.getMinAdjustmentStep()));
        }
        if (putScalingPolicyRequest.getMinAdjustmentMagnitude() != null) {
            request.addParameter("MinAdjustmentMagnitude", StringUtils.fromInteger((Integer)putScalingPolicyRequest.getMinAdjustmentMagnitude()));
        }
        if (putScalingPolicyRequest.getScalingAdjustment() != null) {
            request.addParameter("ScalingAdjustment", StringUtils.fromInteger((Integer)putScalingPolicyRequest.getScalingAdjustment()));
        }
        if (putScalingPolicyRequest.getCooldown() != null) {
            request.addParameter("Cooldown", StringUtils.fromInteger((Integer)putScalingPolicyRequest.getCooldown()));
        }
        if (putScalingPolicyRequest.getMetricAggregationType() != null) {
            request.addParameter("MetricAggregationType", StringUtils.fromString((String)putScalingPolicyRequest.getMetricAggregationType()));
        }
        if (!putScalingPolicyRequest.getStepAdjustments().isEmpty() || !((SdkInternalList)putScalingPolicyRequest.getStepAdjustments()).isAutoConstruct()) {
            SdkInternalList stepAdjustmentsList = (SdkInternalList)putScalingPolicyRequest.getStepAdjustments();
            int stepAdjustmentsListIndex = 1;
            for (StepAdjustment stepAdjustmentsListValue : stepAdjustmentsList) {
                if (stepAdjustmentsListValue.getMetricIntervalLowerBound() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalLowerBound", StringUtils.fromDouble((Double)stepAdjustmentsListValue.getMetricIntervalLowerBound()));
                }
                if (stepAdjustmentsListValue.getMetricIntervalUpperBound() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalUpperBound", StringUtils.fromDouble((Double)stepAdjustmentsListValue.getMetricIntervalUpperBound()));
                }
                if (stepAdjustmentsListValue.getScalingAdjustment() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".ScalingAdjustment", StringUtils.fromInteger((Integer)stepAdjustmentsListValue.getScalingAdjustment()));
                }
                ++stepAdjustmentsListIndex;
            }
        }
        if (putScalingPolicyRequest.getEstimatedInstanceWarmup() != null) {
            request.addParameter("EstimatedInstanceWarmup", StringUtils.fromInteger((Integer)putScalingPolicyRequest.getEstimatedInstanceWarmup()));
        }
        if ((targetTrackingConfiguration = putScalingPolicyRequest.getTargetTrackingConfiguration()) != null) {
            CustomizedMetricSpecification customizedMetricSpecification;
            PredefinedMetricSpecification predefinedMetricSpecification = targetTrackingConfiguration.getPredefinedMetricSpecification();
            if (predefinedMetricSpecification != null) {
                if (predefinedMetricSpecification.getPredefinedMetricType() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.PredefinedMetricType", StringUtils.fromString((String)predefinedMetricSpecification.getPredefinedMetricType()));
                }
                if (predefinedMetricSpecification.getResourceLabel() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.ResourceLabel", StringUtils.fromString((String)predefinedMetricSpecification.getResourceLabel()));
                }
            }
            if ((customizedMetricSpecification = targetTrackingConfiguration.getCustomizedMetricSpecification()) != null) {
                if (customizedMetricSpecification.getMetricName() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.MetricName", StringUtils.fromString((String)customizedMetricSpecification.getMetricName()));
                }
                if (customizedMetricSpecification.getNamespace() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Namespace", StringUtils.fromString((String)customizedMetricSpecification.getNamespace()));
                }
                if (!customizedMetricSpecification.getDimensions().isEmpty() || !((SdkInternalList)customizedMetricSpecification.getDimensions()).isAutoConstruct()) {
                    SdkInternalList dimensionsList = (SdkInternalList)customizedMetricSpecification.getDimensions();
                    int dimensionsListIndex = 1;
                    for (MetricDimension dimensionsListValue : dimensionsList) {
                        if (dimensionsListValue.getName() != null) {
                            request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                        }
                        if (dimensionsListValue.getValue() != null) {
                            request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                        }
                        ++dimensionsListIndex;
                    }
                }
                if (customizedMetricSpecification.getStatistic() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Statistic", StringUtils.fromString((String)customizedMetricSpecification.getStatistic()));
                }
                if (customizedMetricSpecification.getUnit() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Unit", StringUtils.fromString((String)customizedMetricSpecification.getUnit()));
                }
            }
            if (targetTrackingConfiguration.getTargetValue() != null) {
                request.addParameter("TargetTrackingConfiguration.TargetValue", StringUtils.fromDouble((Double)targetTrackingConfiguration.getTargetValue()));
            }
            if (targetTrackingConfiguration.getDisableScaleIn() != null) {
                request.addParameter("TargetTrackingConfiguration.DisableScaleIn", StringUtils.fromBoolean((Boolean)targetTrackingConfiguration.getDisableScaleIn()));
            }
        }
        if (putScalingPolicyRequest.getEnabled() != null) {
            request.addParameter("Enabled", StringUtils.fromBoolean((Boolean)putScalingPolicyRequest.getEnabled()));
        }
        return request;
    }
}

