/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.PredictiveScalingMaxCapacityBreachBehavior;
import com.amazonaws.services.autoscaling.model.PredictiveScalingMetricSpecification;
import com.amazonaws.services.autoscaling.model.PredictiveScalingMode;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PredictiveScalingConfiguration
implements Serializable,
Cloneable {
    private SdkInternalList<PredictiveScalingMetricSpecification> metricSpecifications;
    private String mode;
    private Integer schedulingBufferTime;
    private String maxCapacityBreachBehavior;
    private Integer maxCapacityBuffer;

    public List<PredictiveScalingMetricSpecification> getMetricSpecifications() {
        if (this.metricSpecifications == null) {
            this.metricSpecifications = new SdkInternalList();
        }
        return this.metricSpecifications;
    }

    public void setMetricSpecifications(Collection<PredictiveScalingMetricSpecification> metricSpecifications) {
        if (metricSpecifications == null) {
            this.metricSpecifications = null;
            return;
        }
        this.metricSpecifications = new SdkInternalList(metricSpecifications);
    }

    public PredictiveScalingConfiguration withMetricSpecifications(PredictiveScalingMetricSpecification ... metricSpecifications) {
        if (this.metricSpecifications == null) {
            this.setMetricSpecifications((Collection<PredictiveScalingMetricSpecification>)new SdkInternalList(metricSpecifications.length));
        }
        for (PredictiveScalingMetricSpecification ele : metricSpecifications) {
            this.metricSpecifications.add((Object)ele);
        }
        return this;
    }

    public PredictiveScalingConfiguration withMetricSpecifications(Collection<PredictiveScalingMetricSpecification> metricSpecifications) {
        this.setMetricSpecifications(metricSpecifications);
        return this;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public PredictiveScalingConfiguration withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public PredictiveScalingConfiguration withMode(PredictiveScalingMode mode) {
        this.mode = mode.toString();
        return this;
    }

    public void setSchedulingBufferTime(Integer schedulingBufferTime) {
        this.schedulingBufferTime = schedulingBufferTime;
    }

    public Integer getSchedulingBufferTime() {
        return this.schedulingBufferTime;
    }

    public PredictiveScalingConfiguration withSchedulingBufferTime(Integer schedulingBufferTime) {
        this.setSchedulingBufferTime(schedulingBufferTime);
        return this;
    }

    public void setMaxCapacityBreachBehavior(String maxCapacityBreachBehavior) {
        this.maxCapacityBreachBehavior = maxCapacityBreachBehavior;
    }

    public String getMaxCapacityBreachBehavior() {
        return this.maxCapacityBreachBehavior;
    }

    public PredictiveScalingConfiguration withMaxCapacityBreachBehavior(String maxCapacityBreachBehavior) {
        this.setMaxCapacityBreachBehavior(maxCapacityBreachBehavior);
        return this;
    }

    public PredictiveScalingConfiguration withMaxCapacityBreachBehavior(PredictiveScalingMaxCapacityBreachBehavior maxCapacityBreachBehavior) {
        this.maxCapacityBreachBehavior = maxCapacityBreachBehavior.toString();
        return this;
    }

    public void setMaxCapacityBuffer(Integer maxCapacityBuffer) {
        this.maxCapacityBuffer = maxCapacityBuffer;
    }

    public Integer getMaxCapacityBuffer() {
        return this.maxCapacityBuffer;
    }

    public PredictiveScalingConfiguration withMaxCapacityBuffer(Integer maxCapacityBuffer) {
        this.setMaxCapacityBuffer(maxCapacityBuffer);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricSpecifications() != null) {
            sb.append("MetricSpecifications: ").append(this.getMetricSpecifications()).append(",");
        }
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getSchedulingBufferTime() != null) {
            sb.append("SchedulingBufferTime: ").append(this.getSchedulingBufferTime()).append(",");
        }
        if (this.getMaxCapacityBreachBehavior() != null) {
            sb.append("MaxCapacityBreachBehavior: ").append(this.getMaxCapacityBreachBehavior()).append(",");
        }
        if (this.getMaxCapacityBuffer() != null) {
            sb.append("MaxCapacityBuffer: ").append(this.getMaxCapacityBuffer());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveScalingConfiguration)) {
            return false;
        }
        PredictiveScalingConfiguration other = (PredictiveScalingConfiguration)obj;
        if (other.getMetricSpecifications() == null ^ this.getMetricSpecifications() == null) {
            return false;
        }
        if (other.getMetricSpecifications() != null && !other.getMetricSpecifications().equals(this.getMetricSpecifications())) {
            return false;
        }
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getSchedulingBufferTime() == null ^ this.getSchedulingBufferTime() == null) {
            return false;
        }
        if (other.getSchedulingBufferTime() != null && !other.getSchedulingBufferTime().equals(this.getSchedulingBufferTime())) {
            return false;
        }
        if (other.getMaxCapacityBreachBehavior() == null ^ this.getMaxCapacityBreachBehavior() == null) {
            return false;
        }
        if (other.getMaxCapacityBreachBehavior() != null && !other.getMaxCapacityBreachBehavior().equals(this.getMaxCapacityBreachBehavior())) {
            return false;
        }
        if (other.getMaxCapacityBuffer() == null ^ this.getMaxCapacityBuffer() == null) {
            return false;
        }
        return other.getMaxCapacityBuffer() == null || other.getMaxCapacityBuffer().equals(this.getMaxCapacityBuffer());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricSpecifications() == null ? 0 : this.getMetricSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getSchedulingBufferTime() == null ? 0 : this.getSchedulingBufferTime().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCapacityBreachBehavior() == null ? 0 : this.getMaxCapacityBreachBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCapacityBuffer() == null ? 0 : this.getMaxCapacityBuffer().hashCode());
        return hashCode;
    }

    public PredictiveScalingConfiguration clone() {
        try {
            return (PredictiveScalingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

