/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscalingplans;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.autoscalingplans.AWSAutoScalingPlansAsync;
import com.amazonaws.services.autoscalingplans.AWSAutoScalingPlansAsyncClientBuilder;
import com.amazonaws.services.autoscalingplans.AWSAutoScalingPlansClient;
import com.amazonaws.services.autoscalingplans.model.CreateScalingPlanRequest;
import com.amazonaws.services.autoscalingplans.model.CreateScalingPlanResult;
import com.amazonaws.services.autoscalingplans.model.DeleteScalingPlanRequest;
import com.amazonaws.services.autoscalingplans.model.DeleteScalingPlanResult;
import com.amazonaws.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest;
import com.amazonaws.services.autoscalingplans.model.DescribeScalingPlanResourcesResult;
import com.amazonaws.services.autoscalingplans.model.DescribeScalingPlansRequest;
import com.amazonaws.services.autoscalingplans.model.DescribeScalingPlansResult;
import com.amazonaws.services.autoscalingplans.model.UpdateScalingPlanRequest;
import com.amazonaws.services.autoscalingplans.model.UpdateScalingPlanResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSAutoScalingPlansAsyncClient
extends AWSAutoScalingPlansClient
implements AWSAutoScalingPlansAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSAutoScalingPlansAsyncClientBuilder asyncBuilder() {
        return AWSAutoScalingPlansAsyncClientBuilder.standard();
    }

    AWSAutoScalingPlansAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateScalingPlanResult> createScalingPlanAsync(CreateScalingPlanRequest request) {
        return this.createScalingPlanAsync(request, null);
    }

    @Override
    public Future<CreateScalingPlanResult> createScalingPlanAsync(CreateScalingPlanRequest request, final AsyncHandler<CreateScalingPlanRequest, CreateScalingPlanResult> asyncHandler) {
        final CreateScalingPlanRequest finalRequest = (CreateScalingPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateScalingPlanResult>(){

            @Override
            public CreateScalingPlanResult call() throws Exception {
                CreateScalingPlanResult result = null;
                try {
                    result = AWSAutoScalingPlansAsyncClient.this.executeCreateScalingPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteScalingPlanResult> deleteScalingPlanAsync(DeleteScalingPlanRequest request) {
        return this.deleteScalingPlanAsync(request, null);
    }

    @Override
    public Future<DeleteScalingPlanResult> deleteScalingPlanAsync(DeleteScalingPlanRequest request, final AsyncHandler<DeleteScalingPlanRequest, DeleteScalingPlanResult> asyncHandler) {
        final DeleteScalingPlanRequest finalRequest = (DeleteScalingPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteScalingPlanResult>(){

            @Override
            public DeleteScalingPlanResult call() throws Exception {
                DeleteScalingPlanResult result = null;
                try {
                    result = AWSAutoScalingPlansAsyncClient.this.executeDeleteScalingPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScalingPlanResourcesResult> describeScalingPlanResourcesAsync(DescribeScalingPlanResourcesRequest request) {
        return this.describeScalingPlanResourcesAsync(request, null);
    }

    @Override
    public Future<DescribeScalingPlanResourcesResult> describeScalingPlanResourcesAsync(DescribeScalingPlanResourcesRequest request, final AsyncHandler<DescribeScalingPlanResourcesRequest, DescribeScalingPlanResourcesResult> asyncHandler) {
        final DescribeScalingPlanResourcesRequest finalRequest = (DescribeScalingPlanResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeScalingPlanResourcesResult>(){

            @Override
            public DescribeScalingPlanResourcesResult call() throws Exception {
                DescribeScalingPlanResourcesResult result = null;
                try {
                    result = AWSAutoScalingPlansAsyncClient.this.executeDescribeScalingPlanResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScalingPlansResult> describeScalingPlansAsync(DescribeScalingPlansRequest request) {
        return this.describeScalingPlansAsync(request, null);
    }

    @Override
    public Future<DescribeScalingPlansResult> describeScalingPlansAsync(DescribeScalingPlansRequest request, final AsyncHandler<DescribeScalingPlansRequest, DescribeScalingPlansResult> asyncHandler) {
        final DescribeScalingPlansRequest finalRequest = (DescribeScalingPlansRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeScalingPlansResult>(){

            @Override
            public DescribeScalingPlansResult call() throws Exception {
                DescribeScalingPlansResult result = null;
                try {
                    result = AWSAutoScalingPlansAsyncClient.this.executeDescribeScalingPlans(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateScalingPlanResult> updateScalingPlanAsync(UpdateScalingPlanRequest request) {
        return this.updateScalingPlanAsync(request, null);
    }

    @Override
    public Future<UpdateScalingPlanResult> updateScalingPlanAsync(UpdateScalingPlanRequest request, final AsyncHandler<UpdateScalingPlanRequest, UpdateScalingPlanResult> asyncHandler) {
        final UpdateScalingPlanRequest finalRequest = (UpdateScalingPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateScalingPlanResult>(){

            @Override
            public UpdateScalingPlanResult call() throws Exception {
                UpdateScalingPlanResult result = null;
                try {
                    result = AWSAutoScalingPlansAsyncClient.this.executeUpdateScalingPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

