/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.bedrockruntime.AmazonBedrockRuntimeAsync;
import com.amazonaws.services.bedrockruntime.AmazonBedrockRuntimeAsyncClientBuilder;
import com.amazonaws.services.bedrockruntime.AmazonBedrockRuntimeClient;
import com.amazonaws.services.bedrockruntime.model.ConverseRequest;
import com.amazonaws.services.bedrockruntime.model.ConverseResult;
import com.amazonaws.services.bedrockruntime.model.InvokeModelRequest;
import com.amazonaws.services.bedrockruntime.model.InvokeModelResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonBedrockRuntimeAsyncClient
extends AmazonBedrockRuntimeClient
implements AmazonBedrockRuntimeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonBedrockRuntimeAsyncClientBuilder asyncBuilder() {
        return AmazonBedrockRuntimeAsyncClientBuilder.standard();
    }

    AmazonBedrockRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonBedrockRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ConverseResult> converseAsync(ConverseRequest request) {
        return this.converseAsync(request, null);
    }

    @Override
    public Future<ConverseResult> converseAsync(ConverseRequest request, final AsyncHandler<ConverseRequest, ConverseResult> asyncHandler) {
        final ConverseRequest finalRequest = (ConverseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ConverseResult>(){

            @Override
            public ConverseResult call() throws Exception {
                ConverseResult result = null;
                try {
                    result = AmazonBedrockRuntimeAsyncClient.this.executeConverse(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InvokeModelResult> invokeModelAsync(InvokeModelRequest request) {
        return this.invokeModelAsync(request, null);
    }

    @Override
    public Future<InvokeModelResult> invokeModelAsync(InvokeModelRequest request, final AsyncHandler<InvokeModelRequest, InvokeModelResult> asyncHandler) {
        final InvokeModelRequest finalRequest = (InvokeModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InvokeModelResult>(){

            @Override
            public InvokeModelResult call() throws Exception {
                InvokeModelResult result = null;
                try {
                    result = AmazonBedrockRuntimeAsyncClient.this.executeInvokeModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

