/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockruntime.model.ImageFormat;
import com.amazonaws.services.bedrockruntime.model.ImageSource;
import com.amazonaws.services.bedrockruntime.model.transform.ImageBlockMarshaller;
import java.io.Serializable;

public class ImageBlock
implements Serializable,
Cloneable,
StructuredPojo {
    private String format;
    private ImageSource source;

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public ImageBlock withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public ImageBlock withFormat(ImageFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setSource(ImageSource source) {
        this.source = source;
    }

    public ImageSource getSource() {
        return this.source;
    }

    public ImageBlock withSource(ImageSource source) {
        this.setSource(source);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageBlock)) {
            return false;
        }
        ImageBlock other = (ImageBlock)obj;
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        return other.getSource() == null || other.getSource().equals(this.getSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        return hashCode;
    }

    public ImageBlock clone() {
        try {
            return (ImageBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageBlockMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

