/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockruntime.model.SystemContentBlock;

@SdkInternalApi
public class SystemContentBlockMarshaller {
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("text").build();
    private static final MarshallingInfo<StructuredPojo> GUARDCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("guardContent").build();
    private static final SystemContentBlockMarshaller instance = new SystemContentBlockMarshaller();

    public static SystemContentBlockMarshaller getInstance() {
        return instance;
    }

    public void marshall(SystemContentBlock systemContentBlock, ProtocolMarshaller protocolMarshaller) {
        if (systemContentBlock == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)systemContentBlock.getText(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)systemContentBlock.getGuardContent(), GUARDCONTENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

